<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStateResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetStateResponse
 * @subpackage Structs
 */
class GetStateResponse extends AbstractStructBase
{
    /**
     * The IsAgentValid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAgentValid;
    /**
     * The IsValid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsValid;
    /**
     * The StateAbbreviation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StateAbbreviation;
    /**
     * The ValidationErrorInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ErrorInformation
     */
    public $ValidationErrorInformation;
    /**
     * The GetStateResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GetStateResponse
     */
    public $GetStateResult;
    /**
     * Constructor method for GetStateResponse
     * @uses GetStateResponse::setIsAgentValid()
     * @uses GetStateResponse::setIsValid()
     * @uses GetStateResponse::setStateAbbreviation()
     * @uses GetStateResponse::setValidationErrorInformation()
     * @uses GetStateResponse::setGetStateResult()
     * @param bool $isAgentValid
     * @param bool $isValid
     * @param string $stateAbbreviation
     * @param \StructType\ErrorInformation $validationErrorInformation
     * @param \StructType\GetStateResponse $getStateResult
     */
    public function __construct($isAgentValid = null, $isValid = null, $stateAbbreviation = null, \StructType\ErrorInformation $validationErrorInformation = null, \StructType\GetStateResponse $getStateResult = null)
    {
        $this
            ->setIsAgentValid($isAgentValid)
            ->setIsValid($isValid)
            ->setStateAbbreviation($stateAbbreviation)
            ->setValidationErrorInformation($validationErrorInformation)
            ->setGetStateResult($getStateResult);
    }
    /**
     * Get IsAgentValid value
     * @return bool|null
     */
    public function getIsAgentValid()
    {
        return $this->IsAgentValid;
    }
    /**
     * Set IsAgentValid value
     * @param bool $isAgentValid
     * @return \StructType\GetStateResponse
     */
    public function setIsAgentValid($isAgentValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAgentValid) && !is_bool($isAgentValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAgentValid)), __LINE__);
        }
        $this->IsAgentValid = $isAgentValid;
        return $this;
    }
    /**
     * Get IsValid value
     * @return bool|null
     */
    public function getIsValid()
    {
        return $this->IsValid;
    }
    /**
     * Set IsValid value
     * @param bool $isValid
     * @return \StructType\GetStateResponse
     */
    public function setIsValid($isValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValid) && !is_bool($isValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isValid)), __LINE__);
        }
        $this->IsValid = $isValid;
        return $this;
    }
    /**
     * Get StateAbbreviation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStateAbbreviation()
    {
        return isset($this->StateAbbreviation) ? $this->StateAbbreviation : null;
    }
    /**
     * Set StateAbbreviation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stateAbbreviation
     * @return \StructType\GetStateResponse
     */
    public function setStateAbbreviation($stateAbbreviation = null)
    {
        // validation for constraint: string
        if (!is_null($stateAbbreviation) && !is_string($stateAbbreviation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateAbbreviation)), __LINE__);
        }
        if (is_null($stateAbbreviation) || (is_array($stateAbbreviation) && empty($stateAbbreviation))) {
            unset($this->StateAbbreviation);
        } else {
            $this->StateAbbreviation = $stateAbbreviation;
        }
        return $this;
    }
    /**
     * Get ValidationErrorInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ErrorInformation|null
     */
    public function getValidationErrorInformation()
    {
        return isset($this->ValidationErrorInformation) ? $this->ValidationErrorInformation : null;
    }
    /**
     * Set ValidationErrorInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ErrorInformation $validationErrorInformation
     * @return \StructType\GetStateResponse
     */
    public function setValidationErrorInformation(\StructType\ErrorInformation $validationErrorInformation = null)
    {
        if (is_null($validationErrorInformation) || (is_array($validationErrorInformation) && empty($validationErrorInformation))) {
            unset($this->ValidationErrorInformation);
        } else {
            $this->ValidationErrorInformation = $validationErrorInformation;
        }
        return $this;
    }
    /**
     * Get GetStateResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GetStateResponse|null
     */
    public function getGetStateResult()
    {
        return isset($this->GetStateResult) ? $this->GetStateResult : null;
    }
    /**
     * Set GetStateResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\GetStateResponse $getStateResult
     * @return \StructType\GetStateResponse
     */
    public function setGetStateResult(\StructType\GetStateResponse $getStateResult = null)
    {
        if (is_null($getStateResult) || (is_array($getStateResult) && empty($getStateResult))) {
            unset($this->GetStateResult);
        } else {
            $this->GetStateResult = $getStateResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetStateResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
