<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetListBill StructType
 * @subpackage Structs
 */
class GetListBill extends AbstractStructBase
{
    /**
     * The listBillNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $listBillNumber;
    /**
     * Constructor method for GetListBill
     * @uses GetListBill::setListBillNumber()
     * @param string $listBillNumber
     */
    public function __construct($listBillNumber = null)
    {
        $this
            ->setListBillNumber($listBillNumber);
    }
    /**
     * Get listBillNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getListBillNumber()
    {
        return isset($this->listBillNumber) ? $this->listBillNumber : null;
    }
    /**
     * Set listBillNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $listBillNumber
     * @return \StructType\GetListBill
     */
    public function setListBillNumber($listBillNumber = null)
    {
        // validation for constraint: string
        if (!is_null($listBillNumber) && !is_string($listBillNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($listBillNumber)), __LINE__);
        }
        if (is_null($listBillNumber) || (is_array($listBillNumber) && empty($listBillNumber))) {
            unset($this->listBillNumber);
        } else {
            $this->listBillNumber = $listBillNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetListBill
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
