<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAgentInformation StructType
 * @subpackage Structs
 */
class GetAgentInformation extends AbstractStructBase
{
    /**
     * The enrollerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $enrollerId;
    /**
     * Constructor method for GetAgentInformation
     * @uses GetAgentInformation::setEnrollerId()
     * @param string $enrollerId
     */
    public function __construct($enrollerId = null)
    {
        $this
            ->setEnrollerId($enrollerId);
    }
    /**
     * Get enrollerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnrollerId()
    {
        return isset($this->enrollerId) ? $this->enrollerId : null;
    }
    /**
     * Set enrollerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enrollerId
     * @return \StructType\GetAgentInformation
     */
    public function setEnrollerId($enrollerId = null)
    {
        // validation for constraint: string
        if (!is_null($enrollerId) && !is_string($enrollerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enrollerId)), __LINE__);
        }
        if (is_null($enrollerId) || (is_array($enrollerId) && empty($enrollerId))) {
            unset($this->enrollerId);
        } else {
            $this->enrollerId = $enrollerId;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAgentInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
