<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Benefit StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Benefit
 * @subpackage Structs
 */
class Benefit extends AbstractStructBase
{
    /**
     * The FormattedValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormattedValue;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Premium
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Premium;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Value;
    /**
     * The Which
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Which;
    /**
     * Constructor method for Benefit
     * @uses Benefit::setFormattedValue()
     * @uses Benefit::setName()
     * @uses Benefit::setPremium()
     * @uses Benefit::setValue()
     * @uses Benefit::setWhich()
     * @param string $formattedValue
     * @param string $name
     * @param float $premium
     * @param int $value
     * @param string $which
     */
    public function __construct($formattedValue = null, $name = null, $premium = null, $value = null, $which = null)
    {
        $this
            ->setFormattedValue($formattedValue)
            ->setName($name)
            ->setPremium($premium)
            ->setValue($value)
            ->setWhich($which);
    }
    /**
     * Get FormattedValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormattedValue()
    {
        return isset($this->FormattedValue) ? $this->FormattedValue : null;
    }
    /**
     * Set FormattedValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formattedValue
     * @return \StructType\Benefit
     */
    public function setFormattedValue($formattedValue = null)
    {
        // validation for constraint: string
        if (!is_null($formattedValue) && !is_string($formattedValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formattedValue)), __LINE__);
        }
        if (is_null($formattedValue) || (is_array($formattedValue) && empty($formattedValue))) {
            unset($this->FormattedValue);
        } else {
            $this->FormattedValue = $formattedValue;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\Benefit
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Premium value
     * @return float|null
     */
    public function getPremium()
    {
        return $this->Premium;
    }
    /**
     * Set Premium value
     * @param float $premium
     * @return \StructType\Benefit
     */
    public function setPremium($premium = null)
    {
        $this->Premium = $premium;
        return $this;
    }
    /**
     * Get Value value
     * @return int|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param int $value
     * @return \StructType\Benefit
     */
    public function setValue($value = null)
    {
        // validation for constraint: int
        if (!is_null($value) && !is_numeric($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Which value
     * @return string|null
     */
    public function getWhich()
    {
        return $this->Which;
    }
    /**
     * Set Which value
     * @uses \EnumType\BenefitType::valueIsValid()
     * @uses \EnumType\BenefitType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $which
     * @return \StructType\Benefit
     */
    public function setWhich($which = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BenefitType::valueIsValid($which)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $which, implode(', ', \EnumType\BenefitType::getValidValues())), __LINE__);
        }
        $this->Which = $which;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Benefit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
