<?php

namespace EnumType;

/**
 * This class stands for BenefitType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BenefitType
 * @subpackage Enumerations
 */
class BenefitType
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'Deductible'
     * @return string 'Deductible'
     */
    const VALUE_DEDUCTIBLE = 'Deductible';
    /**
     * Constant for value 'Coinsurance'
     * @return string 'Coinsurance'
     */
    const VALUE_COINSURANCE = 'Coinsurance';
    /**
     * Constant for value 'CoinsuranceMaximumOOP'
     * @return string 'CoinsuranceMaximumOOP'
     */
    const VALUE_COINSURANCE_MAXIMUM_OOP = 'CoinsuranceMaximumOOP';
    /**
     * Constant for value 'CoveragePeriod'
     * @return string 'CoveragePeriod'
     */
    const VALUE_COVERAGE_PERIOD = 'CoveragePeriod';
    /**
     * Constant for value 'CoveragePeriodMaximum'
     * @return string 'CoveragePeriodMaximum'
     */
    const VALUE_COVERAGE_PERIOD_MAXIMUM = 'CoveragePeriodMaximum';
    /**
     * Constant for value 'EnrollmentFee'
     * @return string 'EnrollmentFee'
     */
    const VALUE_ENROLLMENT_FEE = 'EnrollmentFee';
    /**
     * Constant for value 'AssociationFee'
     * @return string 'AssociationFee'
     */
    const VALUE_ASSOCIATION_FEE = 'AssociationFee';
    /**
     * Constant for value 'AdminFee'
     * @return string 'AdminFee'
     */
    const VALUE_ADMIN_FEE = 'AdminFee';
    /**
     * Constant for value 'NetworkFee'
     * @return string 'NetworkFee'
     */
    const VALUE_NETWORK_FEE = 'NetworkFee';
    /**
     * Constant for value 'LifeTimeMaximum'
     * @return string 'LifeTimeMaximum'
     */
    const VALUE_LIFE_TIME_MAXIMUM = 'LifeTimeMaximum';
    /**
     * Constant for value 'TransplantBenefit'
     * @return string 'TransplantBenefit'
     */
    const VALUE_TRANSPLANT_BENEFIT = 'TransplantBenefit';
    /**
     * Constant for value 'OfficeVisitBenefit'
     * @return string 'OfficeVisitBenefit'
     */
    const VALUE_OFFICE_VISIT_BENEFIT = 'OfficeVisitBenefit';
    /**
     * Constant for value 'DentalLevel'
     * @return string 'DentalLevel'
     */
    const VALUE_DENTAL_LEVEL = 'DentalLevel';
    /**
     * Constant for value 'VisionRider'
     * @return string 'VisionRider'
     */
    const VALUE_VISION_RIDER = 'VisionRider';
    /**
     * Constant for value 'ProductFees'
     * @return string 'ProductFees'
     */
    const VALUE_PRODUCT_FEES = 'ProductFees';
    /**
     * Constant for value 'AMEFaceValue'
     * @return string 'AMEFaceValue'
     */
    const VALUE_AMEFACE_VALUE = 'AMEFaceValue';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_DEDUCTIBLE
     * @uses self::VALUE_COINSURANCE
     * @uses self::VALUE_COINSURANCE_MAXIMUM_OOP
     * @uses self::VALUE_COVERAGE_PERIOD
     * @uses self::VALUE_COVERAGE_PERIOD_MAXIMUM
     * @uses self::VALUE_ENROLLMENT_FEE
     * @uses self::VALUE_ASSOCIATION_FEE
     * @uses self::VALUE_ADMIN_FEE
     * @uses self::VALUE_NETWORK_FEE
     * @uses self::VALUE_LIFE_TIME_MAXIMUM
     * @uses self::VALUE_TRANSPLANT_BENEFIT
     * @uses self::VALUE_OFFICE_VISIT_BENEFIT
     * @uses self::VALUE_DENTAL_LEVEL
     * @uses self::VALUE_VISION_RIDER
     * @uses self::VALUE_PRODUCT_FEES
     * @uses self::VALUE_AMEFACE_VALUE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_DEDUCTIBLE,
            self::VALUE_COINSURANCE,
            self::VALUE_COINSURANCE_MAXIMUM_OOP,
            self::VALUE_COVERAGE_PERIOD,
            self::VALUE_COVERAGE_PERIOD_MAXIMUM,
            self::VALUE_ENROLLMENT_FEE,
            self::VALUE_ASSOCIATION_FEE,
            self::VALUE_ADMIN_FEE,
            self::VALUE_NETWORK_FEE,
            self::VALUE_LIFE_TIME_MAXIMUM,
            self::VALUE_TRANSPLANT_BENEFIT,
            self::VALUE_OFFICE_VISIT_BENEFIT,
            self::VALUE_DENTAL_LEVEL,
            self::VALUE_VISION_RIDER,
            self::VALUE_PRODUCT_FEES,
            self::VALUE_AMEFACE_VALUE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
