<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductRate ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfProductRate
 * @subpackage Arrays
 */
class ArrayOfProductRate extends AbstractStructArrayBase
{
    /**
     * The ProductRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ProductRate[]
     */
    public $ProductRate;
    /**
     * Constructor method for ArrayOfProductRate
     * @uses ArrayOfProductRate::setProductRate()
     * @param \StructType\ProductRate[] $productRate
     */
    public function __construct(array $productRate = array())
    {
        $this
            ->setProductRate($productRate);
    }
    /**
     * Get ProductRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ProductRate[]|null
     */
    public function getProductRate()
    {
        return isset($this->ProductRate) ? $this->ProductRate : null;
    }
    /**
     * Set ProductRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ProductRate[] $productRate
     * @return \ArrayType\ArrayOfProductRate
     */
    public function setProductRate(array $productRate = array())
    {
        foreach ($productRate as $arrayOfProductRateProductRateItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductRateProductRateItem instanceof \StructType\ProductRate) {
                throw new \InvalidArgumentException(sprintf('The ProductRate property can only contain items of \StructType\ProductRate, "%s" given', is_object($arrayOfProductRateProductRateItem) ? get_class($arrayOfProductRateProductRateItem) : gettype($arrayOfProductRateProductRateItem)), __LINE__);
            }
        }
        if (is_null($productRate) || (is_array($productRate) && empty($productRate))) {
            unset($this->ProductRate);
        } else {
            $this->ProductRate = $productRate;
        }
        return $this;
    }
    /**
     * Add item to ProductRate value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductRate $item
     * @return \ArrayType\ArrayOfProductRate
     */
    public function addToProductRate(\StructType\ProductRate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductRate) {
            throw new \InvalidArgumentException(sprintf('The ProductRate property can only contain items of \StructType\ProductRate, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductRate[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ProductRate|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ProductRate|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ProductRate|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ProductRate|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ProductRate|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductRate
     */
    public function getAttributeName()
    {
        return 'ProductRate';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfProductRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
