<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAdditionalCoverage ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfAdditionalCoverage
 * @subpackage Arrays
 */
class ArrayOfAdditionalCoverage extends AbstractStructArrayBase
{
    /**
     * The AdditionalCoverage
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdditionalCoverage[]
     */
    public $AdditionalCoverage;
    /**
     * Constructor method for ArrayOfAdditionalCoverage
     * @uses ArrayOfAdditionalCoverage::setAdditionalCoverage()
     * @param \StructType\AdditionalCoverage[] $additionalCoverage
     */
    public function __construct(array $additionalCoverage = array())
    {
        $this
            ->setAdditionalCoverage($additionalCoverage);
    }
    /**
     * Get AdditionalCoverage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdditionalCoverage[]|null
     */
    public function getAdditionalCoverage()
    {
        return isset($this->AdditionalCoverage) ? $this->AdditionalCoverage : null;
    }
    /**
     * Set AdditionalCoverage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalCoverage[] $additionalCoverage
     * @return \ArrayType\ArrayOfAdditionalCoverage
     */
    public function setAdditionalCoverage(array $additionalCoverage = array())
    {
        foreach ($additionalCoverage as $arrayOfAdditionalCoverageAdditionalCoverageItem) {
            // validation for constraint: itemType
            if (!$arrayOfAdditionalCoverageAdditionalCoverageItem instanceof \StructType\AdditionalCoverage) {
                throw new \InvalidArgumentException(sprintf('The AdditionalCoverage property can only contain items of \StructType\AdditionalCoverage, "%s" given', is_object($arrayOfAdditionalCoverageAdditionalCoverageItem) ? get_class($arrayOfAdditionalCoverageAdditionalCoverageItem) : gettype($arrayOfAdditionalCoverageAdditionalCoverageItem)), __LINE__);
            }
        }
        if (is_null($additionalCoverage) || (is_array($additionalCoverage) && empty($additionalCoverage))) {
            unset($this->AdditionalCoverage);
        } else {
            $this->AdditionalCoverage = $additionalCoverage;
        }
        return $this;
    }
    /**
     * Add item to AdditionalCoverage value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalCoverage $item
     * @return \ArrayType\ArrayOfAdditionalCoverage
     */
    public function addToAdditionalCoverage(\StructType\AdditionalCoverage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdditionalCoverage) {
            throw new \InvalidArgumentException(sprintf('The AdditionalCoverage property can only contain items of \StructType\AdditionalCoverage, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AdditionalCoverage[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AdditionalCoverage|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AdditionalCoverage|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AdditionalCoverage|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AdditionalCoverage|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AdditionalCoverage|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AdditionalCoverage
     */
    public function getAttributeName()
    {
        return 'AdditionalCoverage';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAdditionalCoverage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
