<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RatePlansRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RatePlansRequest
 * @subpackage Structs
 */
class RatePlansRequest extends AbstractStructBase
{
    /**
     * The Applicants
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfApplicant
     */
    public $Applicants;
    /**
     * The BrokerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BrokerId;
    /**
     * The Credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Credentials
     */
    public $Credentials;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The IsRewrite
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsRewrite;
    /**
     * The ListBillNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ListBillNumber;
    /**
     * The ProductTypesFilter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProductTypeId
     */
    public $ProductTypesFilter;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The ZipCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for RatePlansRequest
     * @uses RatePlansRequest::setApplicants()
     * @uses RatePlansRequest::setBrokerId()
     * @uses RatePlansRequest::setCredentials()
     * @uses RatePlansRequest::setEffectiveDate()
     * @uses RatePlansRequest::setIsRewrite()
     * @uses RatePlansRequest::setListBillNumber()
     * @uses RatePlansRequest::setProductTypesFilter()
     * @uses RatePlansRequest::setState()
     * @uses RatePlansRequest::setZipCode()
     * @param \ArrayType\ArrayOfApplicant $applicants
     * @param string $brokerId
     * @param \StructType\Credentials $credentials
     * @param string $effectiveDate
     * @param bool $isRewrite
     * @param string $listBillNumber
     * @param \ArrayType\ArrayOfProductTypeId $productTypesFilter
     * @param string $state
     * @param string $zipCode
     */
    public function __construct(\ArrayType\ArrayOfApplicant $applicants = null, $brokerId = null, \StructType\Credentials $credentials = null, $effectiveDate = null, $isRewrite = null, $listBillNumber = null, \ArrayType\ArrayOfProductTypeId $productTypesFilter = null, $state = null, $zipCode = null)
    {
        $this
            ->setApplicants($applicants)
            ->setBrokerId($brokerId)
            ->setCredentials($credentials)
            ->setEffectiveDate($effectiveDate)
            ->setIsRewrite($isRewrite)
            ->setListBillNumber($listBillNumber)
            ->setProductTypesFilter($productTypesFilter)
            ->setState($state)
            ->setZipCode($zipCode);
    }
    /**
     * Get Applicants value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfApplicant|null
     */
    public function getApplicants()
    {
        return isset($this->Applicants) ? $this->Applicants : null;
    }
    /**
     * Set Applicants value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfApplicant $applicants
     * @return \StructType\RatePlansRequest
     */
    public function setApplicants(\ArrayType\ArrayOfApplicant $applicants = null)
    {
        if (is_null($applicants) || (is_array($applicants) && empty($applicants))) {
            unset($this->Applicants);
        } else {
            $this->Applicants = $applicants;
        }
        return $this;
    }
    /**
     * Get BrokerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBrokerId()
    {
        return isset($this->BrokerId) ? $this->BrokerId : null;
    }
    /**
     * Set BrokerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $brokerId
     * @return \StructType\RatePlansRequest
     */
    public function setBrokerId($brokerId = null)
    {
        // validation for constraint: string
        if (!is_null($brokerId) && !is_string($brokerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brokerId)), __LINE__);
        }
        if (is_null($brokerId) || (is_array($brokerId) && empty($brokerId))) {
            unset($this->BrokerId);
        } else {
            $this->BrokerId = $brokerId;
        }
        return $this;
    }
    /**
     * Get Credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Credentials|null
     */
    public function getCredentials()
    {
        return isset($this->Credentials) ? $this->Credentials : null;
    }
    /**
     * Set Credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Credentials $credentials
     * @return \StructType\RatePlansRequest
     */
    public function setCredentials(\StructType\Credentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->Credentials);
        } else {
            $this->Credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\RatePlansRequest
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get IsRewrite value
     * @return bool|null
     */
    public function getIsRewrite()
    {
        return $this->IsRewrite;
    }
    /**
     * Set IsRewrite value
     * @param bool $isRewrite
     * @return \StructType\RatePlansRequest
     */
    public function setIsRewrite($isRewrite = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRewrite) && !is_bool($isRewrite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isRewrite)), __LINE__);
        }
        $this->IsRewrite = $isRewrite;
        return $this;
    }
    /**
     * Get ListBillNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getListBillNumber()
    {
        return isset($this->ListBillNumber) ? $this->ListBillNumber : null;
    }
    /**
     * Set ListBillNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $listBillNumber
     * @return \StructType\RatePlansRequest
     */
    public function setListBillNumber($listBillNumber = null)
    {
        // validation for constraint: string
        if (!is_null($listBillNumber) && !is_string($listBillNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($listBillNumber)), __LINE__);
        }
        if (is_null($listBillNumber) || (is_array($listBillNumber) && empty($listBillNumber))) {
            unset($this->ListBillNumber);
        } else {
            $this->ListBillNumber = $listBillNumber;
        }
        return $this;
    }
    /**
     * Get ProductTypesFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProductTypeId|null
     */
    public function getProductTypesFilter()
    {
        return isset($this->ProductTypesFilter) ? $this->ProductTypesFilter : null;
    }
    /**
     * Set ProductTypesFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProductTypeId $productTypesFilter
     * @return \StructType\RatePlansRequest
     */
    public function setProductTypesFilter(\ArrayType\ArrayOfProductTypeId $productTypesFilter = null)
    {
        if (is_null($productTypesFilter) || (is_array($productTypesFilter) && empty($productTypesFilter))) {
            unset($this->ProductTypesFilter);
        } else {
            $this->ProductTypesFilter = $productTypesFilter;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \StructType\RatePlansRequest
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get ZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZipCode()
    {
        return isset($this->ZipCode) ? $this->ZipCode : null;
    }
    /**
     * Set ZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zipCode
     * @return \StructType\RatePlansRequest
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        if (is_null($zipCode) || (is_array($zipCode) && empty($zipCode))) {
            unset($this->ZipCode);
        } else {
            $this->ZipCode = $zipCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RatePlansRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
