<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateCartResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RateCartResponse
 * @subpackage Structs
 */
class RateCartResponse extends AbstractStructBase
{
    /**
     * The AdditionalPlansToOffer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRatedPlan
     */
    public $AdditionalPlansToOffer;
    /**
     * The AvailablePlans
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRatedPlan
     */
    public $AvailablePlans;
    /**
     * The DiscountedPlansToOffer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRatedPlan
     */
    public $DiscountedPlansToOffer;
    /**
     * The EnrollmentFee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $EnrollmentFee;
    /**
     * The InitialPayment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $InitialPayment;
    /**
     * The MonthlyPaymentTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MonthlyPaymentTotal;
    /**
     * The RatedPlans
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRatedPlan
     */
    public $RatedPlans;
    /**
     * The ValidationErrorInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ErrorInformation
     */
    public $ValidationErrorInformation;
    /**
     * The RateCartResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RateCartResponse
     */
    public $RateCartResult;
    /**
     * Constructor method for RateCartResponse
     * @uses RateCartResponse::setAdditionalPlansToOffer()
     * @uses RateCartResponse::setAvailablePlans()
     * @uses RateCartResponse::setDiscountedPlansToOffer()
     * @uses RateCartResponse::setEnrollmentFee()
     * @uses RateCartResponse::setInitialPayment()
     * @uses RateCartResponse::setMonthlyPaymentTotal()
     * @uses RateCartResponse::setRatedPlans()
     * @uses RateCartResponse::setValidationErrorInformation()
     * @uses RateCartResponse::setRateCartResult()
     * @param \ArrayType\ArrayOfRatedPlan $additionalPlansToOffer
     * @param \ArrayType\ArrayOfRatedPlan $availablePlans
     * @param \ArrayType\ArrayOfRatedPlan $discountedPlansToOffer
     * @param float $enrollmentFee
     * @param float $initialPayment
     * @param float $monthlyPaymentTotal
     * @param \ArrayType\ArrayOfRatedPlan $ratedPlans
     * @param \StructType\ErrorInformation $validationErrorInformation
     * @param \StructType\RateCartResponse $rateCartResult
     */
    public function __construct(\ArrayType\ArrayOfRatedPlan $additionalPlansToOffer = null, \ArrayType\ArrayOfRatedPlan $availablePlans = null, \ArrayType\ArrayOfRatedPlan $discountedPlansToOffer = null, $enrollmentFee = null, $initialPayment = null, $monthlyPaymentTotal = null, \ArrayType\ArrayOfRatedPlan $ratedPlans = null, \StructType\ErrorInformation $validationErrorInformation = null, \StructType\RateCartResponse $rateCartResult = null)
    {
        $this
            ->setAdditionalPlansToOffer($additionalPlansToOffer)
            ->setAvailablePlans($availablePlans)
            ->setDiscountedPlansToOffer($discountedPlansToOffer)
            ->setEnrollmentFee($enrollmentFee)
            ->setInitialPayment($initialPayment)
            ->setMonthlyPaymentTotal($monthlyPaymentTotal)
            ->setRatedPlans($ratedPlans)
            ->setValidationErrorInformation($validationErrorInformation)
            ->setRateCartResult($rateCartResult);
    }
    /**
     * Get AdditionalPlansToOffer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRatedPlan|null
     */
    public function getAdditionalPlansToOffer()
    {
        return isset($this->AdditionalPlansToOffer) ? $this->AdditionalPlansToOffer : null;
    }
    /**
     * Set AdditionalPlansToOffer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRatedPlan $additionalPlansToOffer
     * @return \StructType\RateCartResponse
     */
    public function setAdditionalPlansToOffer(\ArrayType\ArrayOfRatedPlan $additionalPlansToOffer = null)
    {
        if (is_null($additionalPlansToOffer) || (is_array($additionalPlansToOffer) && empty($additionalPlansToOffer))) {
            unset($this->AdditionalPlansToOffer);
        } else {
            $this->AdditionalPlansToOffer = $additionalPlansToOffer;
        }
        return $this;
    }
    /**
     * Get AvailablePlans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRatedPlan|null
     */
    public function getAvailablePlans()
    {
        return isset($this->AvailablePlans) ? $this->AvailablePlans : null;
    }
    /**
     * Set AvailablePlans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRatedPlan $availablePlans
     * @return \StructType\RateCartResponse
     */
    public function setAvailablePlans(\ArrayType\ArrayOfRatedPlan $availablePlans = null)
    {
        if (is_null($availablePlans) || (is_array($availablePlans) && empty($availablePlans))) {
            unset($this->AvailablePlans);
        } else {
            $this->AvailablePlans = $availablePlans;
        }
        return $this;
    }
    /**
     * Get DiscountedPlansToOffer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRatedPlan|null
     */
    public function getDiscountedPlansToOffer()
    {
        return isset($this->DiscountedPlansToOffer) ? $this->DiscountedPlansToOffer : null;
    }
    /**
     * Set DiscountedPlansToOffer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRatedPlan $discountedPlansToOffer
     * @return \StructType\RateCartResponse
     */
    public function setDiscountedPlansToOffer(\ArrayType\ArrayOfRatedPlan $discountedPlansToOffer = null)
    {
        if (is_null($discountedPlansToOffer) || (is_array($discountedPlansToOffer) && empty($discountedPlansToOffer))) {
            unset($this->DiscountedPlansToOffer);
        } else {
            $this->DiscountedPlansToOffer = $discountedPlansToOffer;
        }
        return $this;
    }
    /**
     * Get EnrollmentFee value
     * @return float|null
     */
    public function getEnrollmentFee()
    {
        return $this->EnrollmentFee;
    }
    /**
     * Set EnrollmentFee value
     * @param float $enrollmentFee
     * @return \StructType\RateCartResponse
     */
    public function setEnrollmentFee($enrollmentFee = null)
    {
        $this->EnrollmentFee = $enrollmentFee;
        return $this;
    }
    /**
     * Get InitialPayment value
     * @return float|null
     */
    public function getInitialPayment()
    {
        return $this->InitialPayment;
    }
    /**
     * Set InitialPayment value
     * @param float $initialPayment
     * @return \StructType\RateCartResponse
     */
    public function setInitialPayment($initialPayment = null)
    {
        $this->InitialPayment = $initialPayment;
        return $this;
    }
    /**
     * Get MonthlyPaymentTotal value
     * @return float|null
     */
    public function getMonthlyPaymentTotal()
    {
        return $this->MonthlyPaymentTotal;
    }
    /**
     * Set MonthlyPaymentTotal value
     * @param float $monthlyPaymentTotal
     * @return \StructType\RateCartResponse
     */
    public function setMonthlyPaymentTotal($monthlyPaymentTotal = null)
    {
        $this->MonthlyPaymentTotal = $monthlyPaymentTotal;
        return $this;
    }
    /**
     * Get RatedPlans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRatedPlan|null
     */
    public function getRatedPlans()
    {
        return isset($this->RatedPlans) ? $this->RatedPlans : null;
    }
    /**
     * Set RatedPlans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRatedPlan $ratedPlans
     * @return \StructType\RateCartResponse
     */
    public function setRatedPlans(\ArrayType\ArrayOfRatedPlan $ratedPlans = null)
    {
        if (is_null($ratedPlans) || (is_array($ratedPlans) && empty($ratedPlans))) {
            unset($this->RatedPlans);
        } else {
            $this->RatedPlans = $ratedPlans;
        }
        return $this;
    }
    /**
     * Get ValidationErrorInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ErrorInformation|null
     */
    public function getValidationErrorInformation()
    {
        return isset($this->ValidationErrorInformation) ? $this->ValidationErrorInformation : null;
    }
    /**
     * Set ValidationErrorInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ErrorInformation $validationErrorInformation
     * @return \StructType\RateCartResponse
     */
    public function setValidationErrorInformation(\StructType\ErrorInformation $validationErrorInformation = null)
    {
        if (is_null($validationErrorInformation) || (is_array($validationErrorInformation) && empty($validationErrorInformation))) {
            unset($this->ValidationErrorInformation);
        } else {
            $this->ValidationErrorInformation = $validationErrorInformation;
        }
        return $this;
    }
    /**
     * Get RateCartResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RateCartResponse|null
     */
    public function getRateCartResult()
    {
        return isset($this->RateCartResult) ? $this->RateCartResult : null;
    }
    /**
     * Set RateCartResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RateCartResponse $rateCartResult
     * @return \StructType\RateCartResponse
     */
    public function setRateCartResult(\StructType\RateCartResponse $rateCartResult = null)
    {
        if (is_null($rateCartResult) || (is_array($rateCartResult) && empty($rateCartResult))) {
            unset($this->RateCartResult);
        } else {
            $this->RateCartResult = $rateCartResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateCartResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
