<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RateCartRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:RateCartRequest
 * @subpackage Structs
 */
class RateCartRequest extends AbstractStructBase
{
    /**
     * The Applicants
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfApplicant
     */
    public $Applicants;
    /**
     * The BrokerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BrokerId;
    /**
     * The Credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Credentials
     */
    public $Credentials;
    /**
     * The EffectiveDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EffectiveDate;
    /**
     * The IsListBill
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsListBill;
    /**
     * The IsRewrite
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsRewrite;
    /**
     * The ListBillNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ListBillNumber;
    /**
     * The NumberOfTerms
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfTerms;
    /**
     * The OverWriteCartPlans
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OverWriteCartPlans;
    /**
     * The PaymentFrequency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PaymentFrequency;
    /**
     * The PlansToRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfRatedPlan
     */
    public $PlansToRate;
    /**
     * The ProductTypesFilter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProductTypeId
     */
    public $ProductTypesFilter;
    /**
     * The STMTerm
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $STMTerm;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The TerminationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TerminationDate;
    /**
     * The ZipCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for RateCartRequest
     * @uses RateCartRequest::setApplicants()
     * @uses RateCartRequest::setBrokerId()
     * @uses RateCartRequest::setCredentials()
     * @uses RateCartRequest::setEffectiveDate()
     * @uses RateCartRequest::setIsListBill()
     * @uses RateCartRequest::setIsRewrite()
     * @uses RateCartRequest::setListBillNumber()
     * @uses RateCartRequest::setNumberOfTerms()
     * @uses RateCartRequest::setOverWriteCartPlans()
     * @uses RateCartRequest::setPaymentFrequency()
     * @uses RateCartRequest::setPlansToRate()
     * @uses RateCartRequest::setProductTypesFilter()
     * @uses RateCartRequest::setSTMTerm()
     * @uses RateCartRequest::setState()
     * @uses RateCartRequest::setTerminationDate()
     * @uses RateCartRequest::setZipCode()
     * @param \ArrayType\ArrayOfApplicant $applicants
     * @param string $brokerId
     * @param \StructType\Credentials $credentials
     * @param string $effectiveDate
     * @param bool $isListBill
     * @param bool $isRewrite
     * @param string $listBillNumber
     * @param int $numberOfTerms
     * @param bool $overWriteCartPlans
     * @param int $paymentFrequency
     * @param \ArrayType\ArrayOfRatedPlan $plansToRate
     * @param \ArrayType\ArrayOfProductTypeId $productTypesFilter
     * @param int $sTMTerm
     * @param string $state
     * @param string $terminationDate
     * @param string $zipCode
     */
    public function __construct(\ArrayType\ArrayOfApplicant $applicants = null, $brokerId = null, \StructType\Credentials $credentials = null, $effectiveDate = null, $isListBill = null, $isRewrite = null, $listBillNumber = null, $numberOfTerms = null, $overWriteCartPlans = null, $paymentFrequency = null, \ArrayType\ArrayOfRatedPlan $plansToRate = null, \ArrayType\ArrayOfProductTypeId $productTypesFilter = null, $sTMTerm = null, $state = null, $terminationDate = null, $zipCode = null)
    {
        $this
            ->setApplicants($applicants)
            ->setBrokerId($brokerId)
            ->setCredentials($credentials)
            ->setEffectiveDate($effectiveDate)
            ->setIsListBill($isListBill)
            ->setIsRewrite($isRewrite)
            ->setListBillNumber($listBillNumber)
            ->setNumberOfTerms($numberOfTerms)
            ->setOverWriteCartPlans($overWriteCartPlans)
            ->setPaymentFrequency($paymentFrequency)
            ->setPlansToRate($plansToRate)
            ->setProductTypesFilter($productTypesFilter)
            ->setSTMTerm($sTMTerm)
            ->setState($state)
            ->setTerminationDate($terminationDate)
            ->setZipCode($zipCode);
    }
    /**
     * Get Applicants value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfApplicant|null
     */
    public function getApplicants()
    {
        return isset($this->Applicants) ? $this->Applicants : null;
    }
    /**
     * Set Applicants value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfApplicant $applicants
     * @return \StructType\RateCartRequest
     */
    public function setApplicants(\ArrayType\ArrayOfApplicant $applicants = null)
    {
        if (is_null($applicants) || (is_array($applicants) && empty($applicants))) {
            unset($this->Applicants);
        } else {
            $this->Applicants = $applicants;
        }
        return $this;
    }
    /**
     * Get BrokerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBrokerId()
    {
        return isset($this->BrokerId) ? $this->BrokerId : null;
    }
    /**
     * Set BrokerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $brokerId
     * @return \StructType\RateCartRequest
     */
    public function setBrokerId($brokerId = null)
    {
        // validation for constraint: string
        if (!is_null($brokerId) && !is_string($brokerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brokerId)), __LINE__);
        }
        if (is_null($brokerId) || (is_array($brokerId) && empty($brokerId))) {
            unset($this->BrokerId);
        } else {
            $this->BrokerId = $brokerId;
        }
        return $this;
    }
    /**
     * Get Credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Credentials|null
     */
    public function getCredentials()
    {
        return isset($this->Credentials) ? $this->Credentials : null;
    }
    /**
     * Set Credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Credentials $credentials
     * @return \StructType\RateCartRequest
     */
    public function setCredentials(\StructType\Credentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->Credentials);
        } else {
            $this->Credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get EffectiveDate value
     * @return string|null
     */
    public function getEffectiveDate()
    {
        return $this->EffectiveDate;
    }
    /**
     * Set EffectiveDate value
     * @param string $effectiveDate
     * @return \StructType\RateCartRequest
     */
    public function setEffectiveDate($effectiveDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDate) && !is_string($effectiveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDate)), __LINE__);
        }
        $this->EffectiveDate = $effectiveDate;
        return $this;
    }
    /**
     * Get IsListBill value
     * @return bool|null
     */
    public function getIsListBill()
    {
        return $this->IsListBill;
    }
    /**
     * Set IsListBill value
     * @param bool $isListBill
     * @return \StructType\RateCartRequest
     */
    public function setIsListBill($isListBill = null)
    {
        // validation for constraint: boolean
        if (!is_null($isListBill) && !is_bool($isListBill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isListBill)), __LINE__);
        }
        $this->IsListBill = $isListBill;
        return $this;
    }
    /**
     * Get IsRewrite value
     * @return bool|null
     */
    public function getIsRewrite()
    {
        return $this->IsRewrite;
    }
    /**
     * Set IsRewrite value
     * @param bool $isRewrite
     * @return \StructType\RateCartRequest
     */
    public function setIsRewrite($isRewrite = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRewrite) && !is_bool($isRewrite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isRewrite)), __LINE__);
        }
        $this->IsRewrite = $isRewrite;
        return $this;
    }
    /**
     * Get ListBillNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getListBillNumber()
    {
        return isset($this->ListBillNumber) ? $this->ListBillNumber : null;
    }
    /**
     * Set ListBillNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $listBillNumber
     * @return \StructType\RateCartRequest
     */
    public function setListBillNumber($listBillNumber = null)
    {
        // validation for constraint: string
        if (!is_null($listBillNumber) && !is_string($listBillNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($listBillNumber)), __LINE__);
        }
        if (is_null($listBillNumber) || (is_array($listBillNumber) && empty($listBillNumber))) {
            unset($this->ListBillNumber);
        } else {
            $this->ListBillNumber = $listBillNumber;
        }
        return $this;
    }
    /**
     * Get NumberOfTerms value
     * @return int|null
     */
    public function getNumberOfTerms()
    {
        return $this->NumberOfTerms;
    }
    /**
     * Set NumberOfTerms value
     * @param int $numberOfTerms
     * @return \StructType\RateCartRequest
     */
    public function setNumberOfTerms($numberOfTerms = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfTerms) && !is_numeric($numberOfTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfTerms)), __LINE__);
        }
        $this->NumberOfTerms = $numberOfTerms;
        return $this;
    }
    /**
     * Get OverWriteCartPlans value
     * @return bool|null
     */
    public function getOverWriteCartPlans()
    {
        return $this->OverWriteCartPlans;
    }
    /**
     * Set OverWriteCartPlans value
     * @param bool $overWriteCartPlans
     * @return \StructType\RateCartRequest
     */
    public function setOverWriteCartPlans($overWriteCartPlans = null)
    {
        // validation for constraint: boolean
        if (!is_null($overWriteCartPlans) && !is_bool($overWriteCartPlans)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($overWriteCartPlans)), __LINE__);
        }
        $this->OverWriteCartPlans = $overWriteCartPlans;
        return $this;
    }
    /**
     * Get PaymentFrequency value
     * @return int|null
     */
    public function getPaymentFrequency()
    {
        return $this->PaymentFrequency;
    }
    /**
     * Set PaymentFrequency value
     * @param int $paymentFrequency
     * @return \StructType\RateCartRequest
     */
    public function setPaymentFrequency($paymentFrequency = null)
    {
        // validation for constraint: int
        if (!is_null($paymentFrequency) && !is_numeric($paymentFrequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentFrequency)), __LINE__);
        }
        $this->PaymentFrequency = $paymentFrequency;
        return $this;
    }
    /**
     * Get PlansToRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfRatedPlan|null
     */
    public function getPlansToRate()
    {
        return isset($this->PlansToRate) ? $this->PlansToRate : null;
    }
    /**
     * Set PlansToRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfRatedPlan $plansToRate
     * @return \StructType\RateCartRequest
     */
    public function setPlansToRate(\ArrayType\ArrayOfRatedPlan $plansToRate = null)
    {
        if (is_null($plansToRate) || (is_array($plansToRate) && empty($plansToRate))) {
            unset($this->PlansToRate);
        } else {
            $this->PlansToRate = $plansToRate;
        }
        return $this;
    }
    /**
     * Get ProductTypesFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProductTypeId|null
     */
    public function getProductTypesFilter()
    {
        return isset($this->ProductTypesFilter) ? $this->ProductTypesFilter : null;
    }
    /**
     * Set ProductTypesFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProductTypeId $productTypesFilter
     * @return \StructType\RateCartRequest
     */
    public function setProductTypesFilter(\ArrayType\ArrayOfProductTypeId $productTypesFilter = null)
    {
        if (is_null($productTypesFilter) || (is_array($productTypesFilter) && empty($productTypesFilter))) {
            unset($this->ProductTypesFilter);
        } else {
            $this->ProductTypesFilter = $productTypesFilter;
        }
        return $this;
    }
    /**
     * Get STMTerm value
     * @return int|null
     */
    public function getSTMTerm()
    {
        return $this->STMTerm;
    }
    /**
     * Set STMTerm value
     * @param int $sTMTerm
     * @return \StructType\RateCartRequest
     */
    public function setSTMTerm($sTMTerm = null)
    {
        // validation for constraint: int
        if (!is_null($sTMTerm) && !is_numeric($sTMTerm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sTMTerm)), __LINE__);
        }
        $this->STMTerm = $sTMTerm;
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \StructType\RateCartRequest
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get TerminationDate value
     * @return string|null
     */
    public function getTerminationDate()
    {
        return $this->TerminationDate;
    }
    /**
     * Set TerminationDate value
     * @param string $terminationDate
     * @return \StructType\RateCartRequest
     */
    public function setTerminationDate($terminationDate = null)
    {
        // validation for constraint: string
        if (!is_null($terminationDate) && !is_string($terminationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminationDate)), __LINE__);
        }
        $this->TerminationDate = $terminationDate;
        return $this;
    }
    /**
     * Get ZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZipCode()
    {
        return isset($this->ZipCode) ? $this->ZipCode : null;
    }
    /**
     * Set ZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zipCode
     * @return \StructType\RateCartRequest
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        if (is_null($zipCode) || (is_array($zipCode) && empty($zipCode))) {
            unset($this->ZipCode);
        } else {
            $this->ZipCode = $zipCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RateCartRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
