<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetStateRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetStateRequest
 * @subpackage Structs
 */
class GetStateRequest extends AbstractStructBase
{
    /**
     * The BrokerId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BrokerId;
    /**
     * The Credentials
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Credentials
     */
    public $Credentials;
    /**
     * The ZipCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for GetStateRequest
     * @uses GetStateRequest::setBrokerId()
     * @uses GetStateRequest::setCredentials()
     * @uses GetStateRequest::setZipCode()
     * @param string $brokerId
     * @param \StructType\Credentials $credentials
     * @param string $zipCode
     */
    public function __construct($brokerId = null, \StructType\Credentials $credentials = null, $zipCode = null)
    {
        $this
            ->setBrokerId($brokerId)
            ->setCredentials($credentials)
            ->setZipCode($zipCode);
    }
    /**
     * Get BrokerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBrokerId()
    {
        return isset($this->BrokerId) ? $this->BrokerId : null;
    }
    /**
     * Set BrokerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $brokerId
     * @return \StructType\GetStateRequest
     */
    public function setBrokerId($brokerId = null)
    {
        // validation for constraint: string
        if (!is_null($brokerId) && !is_string($brokerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brokerId)), __LINE__);
        }
        if (is_null($brokerId) || (is_array($brokerId) && empty($brokerId))) {
            unset($this->BrokerId);
        } else {
            $this->BrokerId = $brokerId;
        }
        return $this;
    }
    /**
     * Get Credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Credentials|null
     */
    public function getCredentials()
    {
        return isset($this->Credentials) ? $this->Credentials : null;
    }
    /**
     * Set Credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Credentials $credentials
     * @return \StructType\GetStateRequest
     */
    public function setCredentials(\StructType\Credentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->Credentials);
        } else {
            $this->Credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get ZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZipCode()
    {
        return isset($this->ZipCode) ? $this->ZipCode : null;
    }
    /**
     * Set ZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zipCode
     * @return \StructType\GetStateRequest
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        if (is_null($zipCode) || (is_array($zipCode) && empty($zipCode))) {
            unset($this->ZipCode);
        } else {
            $this->ZipCode = $zipCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetStateRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
