<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Applicant StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Applicant
 * @subpackage Structs
 */
class Applicant extends AbstractStructBase
{
    /**
     * The DOB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DOB;
    /**
     * The Gender
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Gender;
    /**
     * The RelationshipType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RelationshipType;
    /**
     * The Smoker
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Smoker;
    /**
     * Constructor method for Applicant
     * @uses Applicant::setDOB()
     * @uses Applicant::setGender()
     * @uses Applicant::setRelationshipType()
     * @uses Applicant::setSmoker()
     * @param string $dOB
     * @param int $gender
     * @param int $relationshipType
     * @param bool $smoker
     */
    public function __construct($dOB = null, $gender = null, $relationshipType = null, $smoker = null)
    {
        $this
            ->setDOB($dOB)
            ->setGender($gender)
            ->setRelationshipType($relationshipType)
            ->setSmoker($smoker);
    }
    /**
     * Get DOB value
     * @return string|null
     */
    public function getDOB()
    {
        return $this->DOB;
    }
    /**
     * Set DOB value
     * @param string $dOB
     * @return \StructType\Applicant
     */
    public function setDOB($dOB = null)
    {
        // validation for constraint: string
        if (!is_null($dOB) && !is_string($dOB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dOB)), __LINE__);
        }
        $this->DOB = $dOB;
        return $this;
    }
    /**
     * Get Gender value
     * @return int|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param int $gender
     * @return \StructType\Applicant
     */
    public function setGender($gender = null)
    {
        // validation for constraint: int
        if (!is_null($gender) && !is_numeric($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get RelationshipType value
     * @return int|null
     */
    public function getRelationshipType()
    {
        return $this->RelationshipType;
    }
    /**
     * Set RelationshipType value
     * @param int $relationshipType
     * @return \StructType\Applicant
     */
    public function setRelationshipType($relationshipType = null)
    {
        // validation for constraint: int
        if (!is_null($relationshipType) && !is_numeric($relationshipType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($relationshipType)), __LINE__);
        }
        $this->RelationshipType = $relationshipType;
        return $this;
    }
    /**
     * Get Smoker value
     * @return bool|null
     */
    public function getSmoker()
    {
        return $this->Smoker;
    }
    /**
     * Set Smoker value
     * @param bool $smoker
     * @return \StructType\Applicant
     */
    public function setSmoker($smoker = null)
    {
        // validation for constraint: boolean
        if (!is_null($smoker) && !is_bool($smoker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($smoker)), __LINE__);
        }
        $this->Smoker = $smoker;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Applicant
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
