<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTerm ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfTerm
 * @subpackage Arrays
 */
class ArrayOfTerm extends AbstractStructArrayBase
{
    /**
     * The Term
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Term[]
     */
    public $Term;
    /**
     * Constructor method for ArrayOfTerm
     * @uses ArrayOfTerm::setTerm()
     * @param \StructType\Term[] $term
     */
    public function __construct(array $term = array())
    {
        $this
            ->setTerm($term);
    }
    /**
     * Get Term value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Term[]|null
     */
    public function getTerm()
    {
        return isset($this->Term) ? $this->Term : null;
    }
    /**
     * Set Term value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Term[] $term
     * @return \ArrayType\ArrayOfTerm
     */
    public function setTerm(array $term = array())
    {
        foreach ($term as $arrayOfTermTermItem) {
            // validation for constraint: itemType
            if (!$arrayOfTermTermItem instanceof \StructType\Term) {
                throw new \InvalidArgumentException(sprintf('The Term property can only contain items of \StructType\Term, "%s" given', is_object($arrayOfTermTermItem) ? get_class($arrayOfTermTermItem) : gettype($arrayOfTermTermItem)), __LINE__);
            }
        }
        if (is_null($term) || (is_array($term) && empty($term))) {
            unset($this->Term);
        } else {
            $this->Term = $term;
        }
        return $this;
    }
    /**
     * Add item to Term value
     * @throws \InvalidArgumentException
     * @param \StructType\Term $item
     * @return \ArrayType\ArrayOfTerm
     */
    public function addToTerm(\StructType\Term $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Term) {
            throw new \InvalidArgumentException(sprintf('The Term property can only contain items of \StructType\Term, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Term[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Term|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Term|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Term|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Term|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Term|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Term
     */
    public function getAttributeName()
    {
        return 'Term';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTerm
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
