<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenerateSnapshot StructType
 * @subpackage Structs
 */
class GenerateSnapshot extends AbstractStructBase
{
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $user;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The inputXml
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $inputXml;
    /**
     * The langCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $langCode;
    /**
     * The environment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $environment;
    /**
     * The entity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $entity;
    /**
     * Constructor method for GenerateSnapshot
     * @uses GenerateSnapshot::setUser()
     * @uses GenerateSnapshot::setPassword()
     * @uses GenerateSnapshot::setInputXml()
     * @uses GenerateSnapshot::setLangCode()
     * @uses GenerateSnapshot::setEnvironment()
     * @uses GenerateSnapshot::setEntity()
     * @param string $user
     * @param string $password
     * @param string $inputXml
     * @param string $langCode
     * @param string $environment
     * @param string $entity
     */
    public function __construct($user = null, $password = null, $inputXml = null, $langCode = null, $environment = null, $entity = null)
    {
        $this
            ->setUser($user)
            ->setPassword($password)
            ->setInputXml($inputXml)
            ->setLangCode($langCode)
            ->setEnvironment($environment)
            ->setEntity($entity);
    }
    /**
     * Get user value
     * @return string|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param string $user
     * @return \StructType\GenerateSnapshot
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GenerateSnapshot
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get inputXml value
     * @return string|null
     */
    public function getInputXml()
    {
        return $this->inputXml;
    }
    /**
     * Set inputXml value
     * @param string $inputXml
     * @return \StructType\GenerateSnapshot
     */
    public function setInputXml($inputXml = null)
    {
        // validation for constraint: string
        if (!is_null($inputXml) && !is_string($inputXml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inputXml)), __LINE__);
        }
        $this->inputXml = $inputXml;
        return $this;
    }
    /**
     * Get langCode value
     * @return string|null
     */
    public function getLangCode()
    {
        return $this->langCode;
    }
    /**
     * Set langCode value
     * @param string $langCode
     * @return \StructType\GenerateSnapshot
     */
    public function setLangCode($langCode = null)
    {
        // validation for constraint: string
        if (!is_null($langCode) && !is_string($langCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($langCode)), __LINE__);
        }
        $this->langCode = $langCode;
        return $this;
    }
    /**
     * Get environment value
     * @return string|null
     */
    public function getEnvironment()
    {
        return $this->environment;
    }
    /**
     * Set environment value
     * @param string $environment
     * @return \StructType\GenerateSnapshot
     */
    public function setEnvironment($environment = null)
    {
        // validation for constraint: string
        if (!is_null($environment) && !is_string($environment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($environment)), __LINE__);
        }
        $this->environment = $environment;
        return $this;
    }
    /**
     * Get entity value
     * @return string|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param string $entity
     * @return \StructType\GenerateSnapshot
     */
    public function setEntity($entity = null)
    {
        // validation for constraint: string
        if (!is_null($entity) && !is_string($entity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entity)), __LINE__);
        }
        $this->entity = $entity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GenerateSnapshot
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
