<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseBO StructType
 * @subpackage Structs
 */
class BaseBO extends AbstractStructBase
{
    /**
     * The ExecutionStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExecutionStatus;
    /**
     * The AffectedRows
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AffectedRows;
    /**
     * The Environment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Environment;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The TargetFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $TargetFields;
    /**
     * The ExceptionMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExceptionMessage;
    /**
     * The ExceptionStackTrace
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExceptionStackTrace;
    /**
     * Constructor method for BaseBO
     * @uses BaseBO::setExecutionStatus()
     * @uses BaseBO::setAffectedRows()
     * @uses BaseBO::setEnvironment()
     * @uses BaseBO::setMessage()
     * @uses BaseBO::setTargetFields()
     * @uses BaseBO::setExceptionMessage()
     * @uses BaseBO::setExceptionStackTrace()
     * @param string $executionStatus
     * @param int $affectedRows
     * @param string $environment
     * @param string $message
     * @param \ArrayType\ArrayOfString $targetFields
     * @param string $exceptionMessage
     * @param string $exceptionStackTrace
     */
    public function __construct($executionStatus = null, $affectedRows = null, $environment = null, $message = null, \ArrayType\ArrayOfString $targetFields = null, $exceptionMessage = null, $exceptionStackTrace = null)
    {
        $this
            ->setExecutionStatus($executionStatus)
            ->setAffectedRows($affectedRows)
            ->setEnvironment($environment)
            ->setMessage($message)
            ->setTargetFields($targetFields)
            ->setExceptionMessage($exceptionMessage)
            ->setExceptionStackTrace($exceptionStackTrace);
    }
    /**
     * Get ExecutionStatus value
     * @return string
     */
    public function getExecutionStatus()
    {
        return $this->ExecutionStatus;
    }
    /**
     * Set ExecutionStatus value
     * @uses \EnumType\StatusTypes::valueIsValid()
     * @uses \EnumType\StatusTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $executionStatus
     * @return \StructType\BaseBO
     */
    public function setExecutionStatus($executionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatusTypes::valueIsValid($executionStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $executionStatus, implode(', ', \EnumType\StatusTypes::getValidValues())), __LINE__);
        }
        $this->ExecutionStatus = $executionStatus;
        return $this;
    }
    /**
     * Get AffectedRows value
     * @return int
     */
    public function getAffectedRows()
    {
        return $this->AffectedRows;
    }
    /**
     * Set AffectedRows value
     * @param int $affectedRows
     * @return \StructType\BaseBO
     */
    public function setAffectedRows($affectedRows = null)
    {
        // validation for constraint: int
        if (!is_null($affectedRows) && !is_numeric($affectedRows)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($affectedRows)), __LINE__);
        }
        $this->AffectedRows = $affectedRows;
        return $this;
    }
    /**
     * Get Environment value
     * @return string|null
     */
    public function getEnvironment()
    {
        return $this->Environment;
    }
    /**
     * Set Environment value
     * @param string $environment
     * @return \StructType\BaseBO
     */
    public function setEnvironment($environment = null)
    {
        // validation for constraint: string
        if (!is_null($environment) && !is_string($environment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($environment)), __LINE__);
        }
        $this->Environment = $environment;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\BaseBO
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get TargetFields value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getTargetFields()
    {
        return $this->TargetFields;
    }
    /**
     * Set TargetFields value
     * @param \ArrayType\ArrayOfString $targetFields
     * @return \StructType\BaseBO
     */
    public function setTargetFields(\ArrayType\ArrayOfString $targetFields = null)
    {
        $this->TargetFields = $targetFields;
        return $this;
    }
    /**
     * Get ExceptionMessage value
     * @return string|null
     */
    public function getExceptionMessage()
    {
        return $this->ExceptionMessage;
    }
    /**
     * Set ExceptionMessage value
     * @param string $exceptionMessage
     * @return \StructType\BaseBO
     */
    public function setExceptionMessage($exceptionMessage = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionMessage) && !is_string($exceptionMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exceptionMessage)), __LINE__);
        }
        $this->ExceptionMessage = $exceptionMessage;
        return $this;
    }
    /**
     * Get ExceptionStackTrace value
     * @return string|null
     */
    public function getExceptionStackTrace()
    {
        return $this->ExceptionStackTrace;
    }
    /**
     * Set ExceptionStackTrace value
     * @param string $exceptionStackTrace
     * @return \StructType\BaseBO
     */
    public function setExceptionStackTrace($exceptionStackTrace = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionStackTrace) && !is_string($exceptionStackTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exceptionStackTrace)), __LINE__);
        }
        $this->ExceptionStackTrace = $exceptionStackTrace;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseBO
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
