<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BOWorkOrder StructType
 * @subpackage Structs
 */
class BOWorkOrder extends BaseBO
{
    /**
     * The Scheduled
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Scheduled;
    /**
     * The EstimatedReads
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EstimatedReads;
    /**
     * The NotBillable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $NotBillable;
    /**
     * The Emergency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Emergency;
    /**
     * The LandlordAgree
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $LandlordAgree;
    /**
     * The Post
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Post;
    /**
     * The SysGen
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SysGen;
    /**
     * The IgnoreDefaultActions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IgnoreDefaultActions;
    /**
     * The Printed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Printed;
    /**
     * The Entity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Entity;
    /**
     * The CustomerNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNo;
    /**
     * The ContractNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContractNo;
    /**
     * The Window
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Window;
    /**
     * The WorkOrderType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WorkOrderType;
    /**
     * The RefWorkOrderNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RefWorkOrderNo;
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Priority;
    /**
     * The Region
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Region;
    /**
     * The ServiceArea
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceArea;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The InventoryNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InventoryNo;
    /**
     * The AppointmentId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AppointmentId;
    /**
     * Constructor method for BOWorkOrder
     * @uses BOWorkOrder::setScheduled()
     * @uses BOWorkOrder::setEstimatedReads()
     * @uses BOWorkOrder::setNotBillable()
     * @uses BOWorkOrder::setEmergency()
     * @uses BOWorkOrder::setLandlordAgree()
     * @uses BOWorkOrder::setPost()
     * @uses BOWorkOrder::setSysGen()
     * @uses BOWorkOrder::setIgnoreDefaultActions()
     * @uses BOWorkOrder::setPrinted()
     * @uses BOWorkOrder::setEntity()
     * @uses BOWorkOrder::setCustomerNo()
     * @uses BOWorkOrder::setContractNo()
     * @uses BOWorkOrder::setWindow()
     * @uses BOWorkOrder::setWorkOrderType()
     * @uses BOWorkOrder::setRefWorkOrderNo()
     * @uses BOWorkOrder::setPriority()
     * @uses BOWorkOrder::setRegion()
     * @uses BOWorkOrder::setServiceArea()
     * @uses BOWorkOrder::setStatus()
     * @uses BOWorkOrder::setPhone()
     * @uses BOWorkOrder::setInventoryNo()
     * @uses BOWorkOrder::setAppointmentId()
     * @param string $scheduled
     * @param bool $estimatedReads
     * @param bool $notBillable
     * @param bool $emergency
     * @param bool $landlordAgree
     * @param bool $post
     * @param bool $sysGen
     * @param bool $ignoreDefaultActions
     * @param bool $printed
     * @param string $entity
     * @param string $customerNo
     * @param string $contractNo
     * @param string $window
     * @param string $workOrderType
     * @param string $refWorkOrderNo
     * @param string $priority
     * @param string $region
     * @param string $serviceArea
     * @param string $status
     * @param string $phone
     * @param string $inventoryNo
     * @param string $appointmentId
     */
    public function __construct($scheduled = null, $estimatedReads = null, $notBillable = null, $emergency = null, $landlordAgree = null, $post = null, $sysGen = null, $ignoreDefaultActions = null, $printed = null, $entity = null, $customerNo = null, $contractNo = null, $window = null, $workOrderType = null, $refWorkOrderNo = null, $priority = null, $region = null, $serviceArea = null, $status = null, $phone = null, $inventoryNo = null, $appointmentId = null)
    {
        $this
            ->setScheduled($scheduled)
            ->setEstimatedReads($estimatedReads)
            ->setNotBillable($notBillable)
            ->setEmergency($emergency)
            ->setLandlordAgree($landlordAgree)
            ->setPost($post)
            ->setSysGen($sysGen)
            ->setIgnoreDefaultActions($ignoreDefaultActions)
            ->setPrinted($printed)
            ->setEntity($entity)
            ->setCustomerNo($customerNo)
            ->setContractNo($contractNo)
            ->setWindow($window)
            ->setWorkOrderType($workOrderType)
            ->setRefWorkOrderNo($refWorkOrderNo)
            ->setPriority($priority)
            ->setRegion($region)
            ->setServiceArea($serviceArea)
            ->setStatus($status)
            ->setPhone($phone)
            ->setInventoryNo($inventoryNo)
            ->setAppointmentId($appointmentId);
    }
    /**
     * Get Scheduled value
     * @return string
     */
    public function getScheduled()
    {
        return $this->Scheduled;
    }
    /**
     * Set Scheduled value
     * @param string $scheduled
     * @return \StructType\BOWorkOrder
     */
    public function setScheduled($scheduled = null)
    {
        // validation for constraint: string
        if (!is_null($scheduled) && !is_string($scheduled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduled)), __LINE__);
        }
        $this->Scheduled = $scheduled;
        return $this;
    }
    /**
     * Get EstimatedReads value
     * @return bool
     */
    public function getEstimatedReads()
    {
        return $this->EstimatedReads;
    }
    /**
     * Set EstimatedReads value
     * @param bool $estimatedReads
     * @return \StructType\BOWorkOrder
     */
    public function setEstimatedReads($estimatedReads = null)
    {
        // validation for constraint: boolean
        if (!is_null($estimatedReads) && !is_bool($estimatedReads)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($estimatedReads)), __LINE__);
        }
        $this->EstimatedReads = $estimatedReads;
        return $this;
    }
    /**
     * Get NotBillable value
     * @return bool
     */
    public function getNotBillable()
    {
        return $this->NotBillable;
    }
    /**
     * Set NotBillable value
     * @param bool $notBillable
     * @return \StructType\BOWorkOrder
     */
    public function setNotBillable($notBillable = null)
    {
        // validation for constraint: boolean
        if (!is_null($notBillable) && !is_bool($notBillable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($notBillable)), __LINE__);
        }
        $this->NotBillable = $notBillable;
        return $this;
    }
    /**
     * Get Emergency value
     * @return bool
     */
    public function getEmergency()
    {
        return $this->Emergency;
    }
    /**
     * Set Emergency value
     * @param bool $emergency
     * @return \StructType\BOWorkOrder
     */
    public function setEmergency($emergency = null)
    {
        // validation for constraint: boolean
        if (!is_null($emergency) && !is_bool($emergency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($emergency)), __LINE__);
        }
        $this->Emergency = $emergency;
        return $this;
    }
    /**
     * Get LandlordAgree value
     * @return bool
     */
    public function getLandlordAgree()
    {
        return $this->LandlordAgree;
    }
    /**
     * Set LandlordAgree value
     * @param bool $landlordAgree
     * @return \StructType\BOWorkOrder
     */
    public function setLandlordAgree($landlordAgree = null)
    {
        // validation for constraint: boolean
        if (!is_null($landlordAgree) && !is_bool($landlordAgree)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($landlordAgree)), __LINE__);
        }
        $this->LandlordAgree = $landlordAgree;
        return $this;
    }
    /**
     * Get Post value
     * @return bool
     */
    public function getPost()
    {
        return $this->Post;
    }
    /**
     * Set Post value
     * @param bool $post
     * @return \StructType\BOWorkOrder
     */
    public function setPost($post = null)
    {
        // validation for constraint: boolean
        if (!is_null($post) && !is_bool($post)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($post)), __LINE__);
        }
        $this->Post = $post;
        return $this;
    }
    /**
     * Get SysGen value
     * @return bool
     */
    public function getSysGen()
    {
        return $this->SysGen;
    }
    /**
     * Set SysGen value
     * @param bool $sysGen
     * @return \StructType\BOWorkOrder
     */
    public function setSysGen($sysGen = null)
    {
        // validation for constraint: boolean
        if (!is_null($sysGen) && !is_bool($sysGen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sysGen)), __LINE__);
        }
        $this->SysGen = $sysGen;
        return $this;
    }
    /**
     * Get IgnoreDefaultActions value
     * @return bool
     */
    public function getIgnoreDefaultActions()
    {
        return $this->IgnoreDefaultActions;
    }
    /**
     * Set IgnoreDefaultActions value
     * @param bool $ignoreDefaultActions
     * @return \StructType\BOWorkOrder
     */
    public function setIgnoreDefaultActions($ignoreDefaultActions = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignoreDefaultActions) && !is_bool($ignoreDefaultActions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($ignoreDefaultActions)), __LINE__);
        }
        $this->IgnoreDefaultActions = $ignoreDefaultActions;
        return $this;
    }
    /**
     * Get Printed value
     * @return bool
     */
    public function getPrinted()
    {
        return $this->Printed;
    }
    /**
     * Set Printed value
     * @param bool $printed
     * @return \StructType\BOWorkOrder
     */
    public function setPrinted($printed = null)
    {
        // validation for constraint: boolean
        if (!is_null($printed) && !is_bool($printed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($printed)), __LINE__);
        }
        $this->Printed = $printed;
        return $this;
    }
    /**
     * Get Entity value
     * @return string|null
     */
    public function getEntity()
    {
        return $this->Entity;
    }
    /**
     * Set Entity value
     * @param string $entity
     * @return \StructType\BOWorkOrder
     */
    public function setEntity($entity = null)
    {
        // validation for constraint: string
        if (!is_null($entity) && !is_string($entity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entity)), __LINE__);
        }
        $this->Entity = $entity;
        return $this;
    }
    /**
     * Get CustomerNo value
     * @return string|null
     */
    public function getCustomerNo()
    {
        return $this->CustomerNo;
    }
    /**
     * Set CustomerNo value
     * @param string $customerNo
     * @return \StructType\BOWorkOrder
     */
    public function setCustomerNo($customerNo = null)
    {
        // validation for constraint: string
        if (!is_null($customerNo) && !is_string($customerNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerNo)), __LINE__);
        }
        $this->CustomerNo = $customerNo;
        return $this;
    }
    /**
     * Get ContractNo value
     * @return string|null
     */
    public function getContractNo()
    {
        return $this->ContractNo;
    }
    /**
     * Set ContractNo value
     * @param string $contractNo
     * @return \StructType\BOWorkOrder
     */
    public function setContractNo($contractNo = null)
    {
        // validation for constraint: string
        if (!is_null($contractNo) && !is_string($contractNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractNo)), __LINE__);
        }
        $this->ContractNo = $contractNo;
        return $this;
    }
    /**
     * Get Window value
     * @return string|null
     */
    public function getWindow()
    {
        return $this->Window;
    }
    /**
     * Set Window value
     * @param string $window
     * @return \StructType\BOWorkOrder
     */
    public function setWindow($window = null)
    {
        // validation for constraint: string
        if (!is_null($window) && !is_string($window)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($window)), __LINE__);
        }
        $this->Window = $window;
        return $this;
    }
    /**
     * Get WorkOrderType value
     * @return string|null
     */
    public function getWorkOrderType()
    {
        return $this->WorkOrderType;
    }
    /**
     * Set WorkOrderType value
     * @param string $workOrderType
     * @return \StructType\BOWorkOrder
     */
    public function setWorkOrderType($workOrderType = null)
    {
        // validation for constraint: string
        if (!is_null($workOrderType) && !is_string($workOrderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workOrderType)), __LINE__);
        }
        $this->WorkOrderType = $workOrderType;
        return $this;
    }
    /**
     * Get RefWorkOrderNo value
     * @return string|null
     */
    public function getRefWorkOrderNo()
    {
        return $this->RefWorkOrderNo;
    }
    /**
     * Set RefWorkOrderNo value
     * @param string $refWorkOrderNo
     * @return \StructType\BOWorkOrder
     */
    public function setRefWorkOrderNo($refWorkOrderNo = null)
    {
        // validation for constraint: string
        if (!is_null($refWorkOrderNo) && !is_string($refWorkOrderNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refWorkOrderNo)), __LINE__);
        }
        $this->RefWorkOrderNo = $refWorkOrderNo;
        return $this;
    }
    /**
     * Get Priority value
     * @return string|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param string $priority
     * @return \StructType\BOWorkOrder
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: string
        if (!is_null($priority) && !is_string($priority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priority)), __LINE__);
        }
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get Region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @param string $region
     * @return \StructType\BOWorkOrder
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($region)), __LINE__);
        }
        $this->Region = $region;
        return $this;
    }
    /**
     * Get ServiceArea value
     * @return string|null
     */
    public function getServiceArea()
    {
        return $this->ServiceArea;
    }
    /**
     * Set ServiceArea value
     * @param string $serviceArea
     * @return \StructType\BOWorkOrder
     */
    public function setServiceArea($serviceArea = null)
    {
        // validation for constraint: string
        if (!is_null($serviceArea) && !is_string($serviceArea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceArea)), __LINE__);
        }
        $this->ServiceArea = $serviceArea;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\BOWorkOrder
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \StructType\BOWorkOrder
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get InventoryNo value
     * @return string|null
     */
    public function getInventoryNo()
    {
        return $this->InventoryNo;
    }
    /**
     * Set InventoryNo value
     * @param string $inventoryNo
     * @return \StructType\BOWorkOrder
     */
    public function setInventoryNo($inventoryNo = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryNo) && !is_string($inventoryNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inventoryNo)), __LINE__);
        }
        $this->InventoryNo = $inventoryNo;
        return $this;
    }
    /**
     * Get AppointmentId value
     * @return string|null
     */
    public function getAppointmentId()
    {
        return $this->AppointmentId;
    }
    /**
     * Set AppointmentId value
     * @param string $appointmentId
     * @return \StructType\BOWorkOrder
     */
    public function setAppointmentId($appointmentId = null)
    {
        // validation for constraint: string
        if (!is_null($appointmentId) && !is_string($appointmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appointmentId)), __LINE__);
        }
        $this->AppointmentId = $appointmentId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BOWorkOrder
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
