<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BOFile StructType
 * @subpackage Structs
 */
class BOFile extends BaseBO
{
    /**
     * The FileLenght
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FileLenght;
    /**
     * The FilePath
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FilePath;
    /**
     * The FileBytes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FileBytes;
    /**
     * Constructor method for BOFile
     * @uses BOFile::setFileLenght()
     * @uses BOFile::setFilePath()
     * @uses BOFile::setFileBytes()
     * @param int $fileLenght
     * @param string $filePath
     * @param string $fileBytes
     */
    public function __construct($fileLenght = null, $filePath = null, $fileBytes = null)
    {
        $this
            ->setFileLenght($fileLenght)
            ->setFilePath($filePath)
            ->setFileBytes($fileBytes);
    }
    /**
     * Get FileLenght value
     * @return int
     */
    public function getFileLenght()
    {
        return $this->FileLenght;
    }
    /**
     * Set FileLenght value
     * @param int $fileLenght
     * @return \StructType\BOFile
     */
    public function setFileLenght($fileLenght = null)
    {
        // validation for constraint: int
        if (!is_null($fileLenght) && !is_numeric($fileLenght)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fileLenght)), __LINE__);
        }
        $this->FileLenght = $fileLenght;
        return $this;
    }
    /**
     * Get FilePath value
     * @return string|null
     */
    public function getFilePath()
    {
        return $this->FilePath;
    }
    /**
     * Set FilePath value
     * @param string $filePath
     * @return \StructType\BOFile
     */
    public function setFilePath($filePath = null)
    {
        // validation for constraint: string
        if (!is_null($filePath) && !is_string($filePath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filePath)), __LINE__);
        }
        $this->FilePath = $filePath;
        return $this;
    }
    /**
     * Get FileBytes value
     * @return string|null
     */
    public function getFileBytes()
    {
        return $this->FileBytes;
    }
    /**
     * Set FileBytes value
     * @param string $fileBytes
     * @return \StructType\BOFile
     */
    public function setFileBytes($fileBytes = null)
    {
        // validation for constraint: string
        if (!is_null($fileBytes) && !is_string($fileBytes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileBytes)), __LINE__);
        }
        $this->FileBytes = $fileBytes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BOFile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
