<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for RDET ServiceType
 * @subpackage Services
 */
class RDET extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RDETestConnection
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RDETestConnection $parameters
     * @return \StructType\RDETestConnectionResponse|bool
     */
    public function RDETestConnection(\StructType\RDETestConnection $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RDETestConnection($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RDETest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RDETest $parameters
     * @return \StructType\RDETestResponse|bool
     */
    public function RDETest(\StructType\RDETest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RDETest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RDETestConnectionResponse|\StructType\RDETestResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
