<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateSnapshot
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSnapshot $parameters
     * @return \StructType\UpdateSnapshotResponse|bool
     */
    public function UpdateSnapshot(\StructType\UpdateSnapshot $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateSnapshot($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateEpiqCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateEpiqCustomer $parameters
     * @return \StructType\UpdateEpiqCustomerResponse|bool
     */
    public function UpdateEpiqCustomer(\StructType\UpdateEpiqCustomer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateEpiqCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCustomerProfile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCustomerProfile $parameters
     * @return \StructType\UpdateCustomerProfileResponse|bool
     */
    public function UpdateCustomerProfile(\StructType\UpdateCustomerProfile $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCustomerProfile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateCustomerProfileResponse|\StructType\UpdateEpiqCustomerResponse|\StructType\UpdateSnapshotResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
