<?php

namespace EnumType;

/**
 * This class stands for StatusTypes EnumType
 * @subpackage Enumerations
 */
class StatusTypes
{
    /**
     * Constant for value 'Ok'
     * @return string 'Ok'
     */
    const VALUE_OK = 'Ok';
    /**
     * Constant for value 'Failure'
     * @return string 'Failure'
     */
    const VALUE_FAILURE = 'Failure';
    /**
     * Constant for value 'ExceptionRaised'
     * @return string 'ExceptionRaised'
     */
    const VALUE_EXCEPTION_RAISED = 'ExceptionRaised';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OK
     * @uses self::VALUE_FAILURE
     * @uses self::VALUE_EXCEPTION_RAISED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OK,
            self::VALUE_FAILURE,
            self::VALUE_EXCEPTION_RAISED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
