<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://198.61.137.99/READiDataExchange/WSRSDataExchange.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://198.61.137.99/READiDataExchange/WSRSDataExchange.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Execute ServiceType
 */
$execute = new \ServiceType\Execute($options);
/**
 * Sample call for ExecuteSP operation/method
 */
if ($execute->ExecuteSP(new \StructType\ExecuteSP()) !== false) {
    print_r($execute->getResult());
} else {
    print_r($execute->getLastError());
}
/**
 * Sample call for ExecuteSPRecordSet operation/method
 */
if ($execute->ExecuteSPRecordSet(new \StructType\ExecuteSPRecordSet()) !== false) {
    print_r($execute->getResult());
} else {
    print_r($execute->getLastError());
}
/**
 * Samples for RDET ServiceType
 */
$rDET = new \ServiceType\RDET($options);
/**
 * Sample call for RDETestConnection operation/method
 */
if ($rDET->RDETestConnection(new \StructType\RDETestConnection()) !== false) {
    print_r($rDET->getResult());
} else {
    print_r($rDET->getLastError());
}
/**
 * Sample call for RDETest operation/method
 */
if ($rDET->RDETest(new \StructType\RDETest()) !== false) {
    print_r($rDET->getResult());
} else {
    print_r($rDET->getLastError());
}
/**
 * Samples for Insert ServiceType
 */
$insert = new \ServiceType\Insert($options);
/**
 * Sample call for InsertReceipt operation/method
 */
if ($insert->InsertReceipt(new \StructType\InsertReceipt()) !== false) {
    print_r($insert->getResult());
} else {
    print_r($insert->getLastError());
}
/**
 * Samples for Void ServiceType
 */
$void = new \ServiceType\Void($options);
/**
 * Sample call for VoidPaymentByLedgerID operation/method
 */
if ($void->VoidPaymentByLedgerID(new \StructType\VoidPaymentByLedgerID()) !== false) {
    print_r($void->getResult());
} else {
    print_r($void->getLastError());
}
/**
 * Sample call for VoidPaymentByReceiptID operation/method
 */
if ($void->VoidPaymentByReceiptID(new \StructType\VoidPaymentByReceiptID()) !== false) {
    print_r($void->getResult());
} else {
    print_r($void->getLastError());
}
/**
 * Samples for Is ServiceType
 */
$is = new \ServiceType\Is($options);
/**
 * Sample call for IsPaymentPosted operation/method
 */
if ($is->IsPaymentPosted(new \StructType\IsPaymentPosted()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Sample call for IsExistingPayment operation/method
 */
if ($is->IsExistingPayment(new \StructType\IsExistingPayment()) !== false) {
    print_r($is->getResult());
} else {
    print_r($is->getLastError());
}
/**
 * Samples for Generate ServiceType
 */
$generate = new \ServiceType\Generate($options);
/**
 * Sample call for GenerateSnapshot operation/method
 */
if ($generate->GenerateSnapshot(new \StructType\GenerateSnapshot()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
/**
 * Sample call for UpdateSnapshot operation/method
 */
if ($update->UpdateSnapshot(new \StructType\UpdateSnapshot()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateEpiqCustomer operation/method
 */
if ($update->UpdateEpiqCustomer(new \StructType\UpdateEpiqCustomer()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCustomerProfile operation/method
 */
if ($update->UpdateCustomerProfile(new \StructType\UpdateCustomerProfile()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for CreateContactLog operation/method
 */
if ($create->CreateContactLog(new \StructType\CreateContactLog()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateWorkOrder operation/method
 */
if ($create->CreateWorkOrder(new \StructType\CreateWorkOrder()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for CreateMailer operation/method
 */
if ($create->CreateMailer(new \StructType\CreateMailer()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetFile operation/method
 */
if ($get->GetFile(new \StructType\GetFile()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
