<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RDETestConnection StructType
 * @subpackage Structs
 */
class RDETestConnection extends AbstractStructBase
{
    /**
     * The username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $username;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The langCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $langCode;
    /**
     * The environment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $environment;
    /**
     * The entity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $entity;
    /**
     * Constructor method for RDETestConnection
     * @uses RDETestConnection::setUsername()
     * @uses RDETestConnection::setPassword()
     * @uses RDETestConnection::setLangCode()
     * @uses RDETestConnection::setEnvironment()
     * @uses RDETestConnection::setEntity()
     * @param string $username
     * @param string $password
     * @param string $langCode
     * @param string $environment
     * @param string $entity
     */
    public function __construct($username = null, $password = null, $langCode = null, $environment = null, $entity = null)
    {
        $this
            ->setUsername($username)
            ->setPassword($password)
            ->setLangCode($langCode)
            ->setEnvironment($environment)
            ->setEntity($entity);
    }
    /**
     * Get username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->username;
    }
    /**
     * Set username value
     * @param string $username
     * @return \StructType\RDETestConnection
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\RDETestConnection
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get langCode value
     * @return string|null
     */
    public function getLangCode()
    {
        return $this->langCode;
    }
    /**
     * Set langCode value
     * @param string $langCode
     * @return \StructType\RDETestConnection
     */
    public function setLangCode($langCode = null)
    {
        // validation for constraint: string
        if (!is_null($langCode) && !is_string($langCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($langCode)), __LINE__);
        }
        $this->langCode = $langCode;
        return $this;
    }
    /**
     * Get environment value
     * @return string|null
     */
    public function getEnvironment()
    {
        return $this->environment;
    }
    /**
     * Set environment value
     * @param string $environment
     * @return \StructType\RDETestConnection
     */
    public function setEnvironment($environment = null)
    {
        // validation for constraint: string
        if (!is_null($environment) && !is_string($environment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($environment)), __LINE__);
        }
        $this->environment = $environment;
        return $this;
    }
    /**
     * Get entity value
     * @return string|null
     */
    public function getEntity()
    {
        return $this->entity;
    }
    /**
     * Set entity value
     * @param string $entity
     * @return \StructType\RDETestConnection
     */
    public function setEntity($entity = null)
    {
        // validation for constraint: string
        if (!is_null($entity) && !is_string($entity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entity)), __LINE__);
        }
        $this->entity = $entity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RDETestConnection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
