<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BOMailer StructType
 * @subpackage Structs
 */
class BOMailer extends BaseBO
{
    /**
     * The Requested
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Requested;
    /**
     * The MailingAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $MailingAddress;
    /**
     * The BillingAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $BillingAddress;
    /**
     * The ServiceAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ServiceAddress;
    /**
     * The Printed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Printed;
    /**
     * The Entity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Entity;
    /**
     * The CustomerNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNo;
    /**
     * The LocationNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocationNo;
    /**
     * The MailerType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MailerType;
    /**
     * The ConsolidationLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConsolidationLevel;
    /**
     * Constructor method for BOMailer
     * @uses BOMailer::setRequested()
     * @uses BOMailer::setMailingAddress()
     * @uses BOMailer::setBillingAddress()
     * @uses BOMailer::setServiceAddress()
     * @uses BOMailer::setPrinted()
     * @uses BOMailer::setEntity()
     * @uses BOMailer::setCustomerNo()
     * @uses BOMailer::setLocationNo()
     * @uses BOMailer::setMailerType()
     * @uses BOMailer::setConsolidationLevel()
     * @param string $requested
     * @param bool $mailingAddress
     * @param bool $billingAddress
     * @param bool $serviceAddress
     * @param bool $printed
     * @param string $entity
     * @param string $customerNo
     * @param string $locationNo
     * @param string $mailerType
     * @param string $consolidationLevel
     */
    public function __construct($requested = null, $mailingAddress = null, $billingAddress = null, $serviceAddress = null, $printed = null, $entity = null, $customerNo = null, $locationNo = null, $mailerType = null, $consolidationLevel = null)
    {
        $this
            ->setRequested($requested)
            ->setMailingAddress($mailingAddress)
            ->setBillingAddress($billingAddress)
            ->setServiceAddress($serviceAddress)
            ->setPrinted($printed)
            ->setEntity($entity)
            ->setCustomerNo($customerNo)
            ->setLocationNo($locationNo)
            ->setMailerType($mailerType)
            ->setConsolidationLevel($consolidationLevel);
    }
    /**
     * Get Requested value
     * @return string
     */
    public function getRequested()
    {
        return $this->Requested;
    }
    /**
     * Set Requested value
     * @param string $requested
     * @return \StructType\BOMailer
     */
    public function setRequested($requested = null)
    {
        // validation for constraint: string
        if (!is_null($requested) && !is_string($requested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requested)), __LINE__);
        }
        $this->Requested = $requested;
        return $this;
    }
    /**
     * Get MailingAddress value
     * @return bool
     */
    public function getMailingAddress()
    {
        return $this->MailingAddress;
    }
    /**
     * Set MailingAddress value
     * @param bool $mailingAddress
     * @return \StructType\BOMailer
     */
    public function setMailingAddress($mailingAddress = null)
    {
        // validation for constraint: boolean
        if (!is_null($mailingAddress) && !is_bool($mailingAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mailingAddress)), __LINE__);
        }
        $this->MailingAddress = $mailingAddress;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return bool
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param bool $billingAddress
     * @return \StructType\BOMailer
     */
    public function setBillingAddress($billingAddress = null)
    {
        // validation for constraint: boolean
        if (!is_null($billingAddress) && !is_bool($billingAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($billingAddress)), __LINE__);
        }
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get ServiceAddress value
     * @return bool
     */
    public function getServiceAddress()
    {
        return $this->ServiceAddress;
    }
    /**
     * Set ServiceAddress value
     * @param bool $serviceAddress
     * @return \StructType\BOMailer
     */
    public function setServiceAddress($serviceAddress = null)
    {
        // validation for constraint: boolean
        if (!is_null($serviceAddress) && !is_bool($serviceAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($serviceAddress)), __LINE__);
        }
        $this->ServiceAddress = $serviceAddress;
        return $this;
    }
    /**
     * Get Printed value
     * @return bool
     */
    public function getPrinted()
    {
        return $this->Printed;
    }
    /**
     * Set Printed value
     * @param bool $printed
     * @return \StructType\BOMailer
     */
    public function setPrinted($printed = null)
    {
        // validation for constraint: boolean
        if (!is_null($printed) && !is_bool($printed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($printed)), __LINE__);
        }
        $this->Printed = $printed;
        return $this;
    }
    /**
     * Get Entity value
     * @return string|null
     */
    public function getEntity()
    {
        return $this->Entity;
    }
    /**
     * Set Entity value
     * @param string $entity
     * @return \StructType\BOMailer
     */
    public function setEntity($entity = null)
    {
        // validation for constraint: string
        if (!is_null($entity) && !is_string($entity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entity)), __LINE__);
        }
        $this->Entity = $entity;
        return $this;
    }
    /**
     * Get CustomerNo value
     * @return string|null
     */
    public function getCustomerNo()
    {
        return $this->CustomerNo;
    }
    /**
     * Set CustomerNo value
     * @param string $customerNo
     * @return \StructType\BOMailer
     */
    public function setCustomerNo($customerNo = null)
    {
        // validation for constraint: string
        if (!is_null($customerNo) && !is_string($customerNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerNo)), __LINE__);
        }
        $this->CustomerNo = $customerNo;
        return $this;
    }
    /**
     * Get LocationNo value
     * @return string|null
     */
    public function getLocationNo()
    {
        return $this->LocationNo;
    }
    /**
     * Set LocationNo value
     * @param string $locationNo
     * @return \StructType\BOMailer
     */
    public function setLocationNo($locationNo = null)
    {
        // validation for constraint: string
        if (!is_null($locationNo) && !is_string($locationNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locationNo)), __LINE__);
        }
        $this->LocationNo = $locationNo;
        return $this;
    }
    /**
     * Get MailerType value
     * @return string|null
     */
    public function getMailerType()
    {
        return $this->MailerType;
    }
    /**
     * Set MailerType value
     * @param string $mailerType
     * @return \StructType\BOMailer
     */
    public function setMailerType($mailerType = null)
    {
        // validation for constraint: string
        if (!is_null($mailerType) && !is_string($mailerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mailerType)), __LINE__);
        }
        $this->MailerType = $mailerType;
        return $this;
    }
    /**
     * Get ConsolidationLevel value
     * @return string|null
     */
    public function getConsolidationLevel()
    {
        return $this->ConsolidationLevel;
    }
    /**
     * Set ConsolidationLevel value
     * @param string $consolidationLevel
     * @return \StructType\BOMailer
     */
    public function setConsolidationLevel($consolidationLevel = null)
    {
        // validation for constraint: string
        if (!is_null($consolidationLevel) && !is_string($consolidationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consolidationLevel)), __LINE__);
        }
        $this->ConsolidationLevel = $consolidationLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BOMailer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
