<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Void ServiceType
 * @subpackage Services
 */
class Void extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named VoidPaymentByLedgerID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VoidPaymentByLedgerID $parameters
     * @return \StructType\VoidPaymentByLedgerIDResponse|bool
     */
    public function VoidPaymentByLedgerID(\StructType\VoidPaymentByLedgerID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->VoidPaymentByLedgerID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VoidPaymentByReceiptID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VoidPaymentByReceiptID $parameters
     * @return \StructType\VoidPaymentByReceiptIDResponse|bool
     */
    public function VoidPaymentByReceiptID(\StructType\VoidPaymentByReceiptID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->VoidPaymentByReceiptID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\VoidPaymentByLedgerIDResponse|\StructType\VoidPaymentByReceiptIDResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
