<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Insert ServiceType
 * @subpackage Services
 */
class Insert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InsertReceipt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertReceipt $parameters
     * @return \StructType\InsertReceiptResponse|bool
     */
    public function InsertReceipt(\StructType\InsertReceipt $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertReceipt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InsertReceiptResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
