<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValueAddedServicesList StructType
 * @subpackage Structs
 */
class ValueAddedServicesList extends AbstractStructBase
{
    /**
     * The ValueAddedService
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $ValueAddedService;
    /**
     * Constructor method for ValueAddedServicesList
     * @uses ValueAddedServicesList::setValueAddedService()
     * @param string[] $valueAddedService
     */
    public function __construct(array $valueAddedService = array())
    {
        $this
            ->setValueAddedService($valueAddedService);
    }
    /**
     * Get ValueAddedService value
     * @return string[]
     */
    public function getValueAddedService()
    {
        return $this->ValueAddedService;
    }
    /**
     * Set ValueAddedService value
     * @uses \EnumType\ValueAddedServiceType::valueIsValid()
     * @uses \EnumType\ValueAddedServiceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $valueAddedService
     * @return \StructType\ValueAddedServicesList
     */
    public function setValueAddedService(array $valueAddedService = array())
    {
        $invalidValues = array();
        foreach ($valueAddedService as $valueAddedServicesListValueAddedServiceItem) {
            if (!\EnumType\ValueAddedServiceType::valueIsValid($valueAddedServicesListValueAddedServiceItem)) {
                $invalidValues[] = var_export($valueAddedServicesListValueAddedServiceItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\ValueAddedServiceType::getValidValues())), __LINE__);
        }
        $this->ValueAddedService = $valueAddedService;
        return $this;
    }
    /**
     * Add item to ValueAddedService value
     * @uses \EnumType\ValueAddedServiceType::valueIsValid()
     * @uses \EnumType\ValueAddedServiceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ValueAddedServicesList
     */
    public function addToValueAddedService($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ValueAddedServiceType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\ValueAddedServiceType::getValidValues())), __LINE__);
        }
        $this->ValueAddedService[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValueAddedServicesList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
