<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RFIDmifarefamilyIdentificationType StructType
 * @subpackage Structs
 */
class RFIDmifarefamilyIdentificationType extends AbstractStructBase
{
    /**
     * The UID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9A-F]{8,8}|[0-9A-F]{14,14}|[0-9A-F]{20,20}
     * @var string
     */
    public $UID;
    /**
     * Constructor method for RFIDmifarefamilyIdentificationType
     * @uses RFIDmifarefamilyIdentificationType::setUID()
     * @param string $uID
     */
    public function __construct($uID = null)
    {
        $this
            ->setUID($uID);
    }
    /**
     * Get UID value
     * @return string
     */
    public function getUID()
    {
        return $this->UID;
    }
    /**
     * Set UID value
     * @param string $uID
     * @return \StructType\RFIDmifarefamilyIdentificationType
     */
    public function setUID($uID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($uID) && !preg_match('/[0-9A-F]{8,8}|[0-9A-F]{14,14}|[0-9A-F]{20,20}/', $uID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9A-F]{8,8}|[0-9A-F]{14,14}|[0-9A-F]{20,20}", "%s" given', var_export($uID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uID) && !is_string($uID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uID)), __LINE__);
        }
        $this->UID = $uID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RFIDmifarefamilyIdentificationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
