<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlugAndChargeIdentificationType StructType
 * @subpackage Structs
 */
class PlugAndChargeIdentificationType extends AbstractStructBase
{
    /**
     * The EVCOID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Za-z]{2}\-?[A-Za-z0-9]{3}\-?C[A-Za-z0-9]{8}[\*|\-]?[\d|X])|([A-Za-z]{2}[\*|\-]?[A-Za-z0-9]{3}[\*|\-]?[A-Za-z0-9]{6}[\*|\-]?[\d|X])
     * @var string
     */
    public $EVCOID;
    /**
     * Constructor method for PlugAndChargeIdentificationType
     * @uses PlugAndChargeIdentificationType::setEVCOID()
     * @param string $eVCOID
     */
    public function __construct($eVCOID = null)
    {
        $this
            ->setEVCOID($eVCOID);
    }
    /**
     * Get EVCOID value
     * @return string
     */
    public function getEVCOID()
    {
        return $this->EVCOID;
    }
    /**
     * Set EVCOID value
     * @param string $eVCOID
     * @return \StructType\PlugAndChargeIdentificationType
     */
    public function setEVCOID($eVCOID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($eVCOID) && !preg_match('/([A-Za-z]{2}\\-?[A-Za-z0-9]{3}\\-?C[A-Za-z0-9]{8}[\\*|\\-]?[\\d|X])|([A-Za-z]{2}[\\*|\\-]?[A-Za-z0-9]{3}[\\*|\\-]?[A-Za-z0-9]{6}[\\*|\\-]?[\\d|X])/', $eVCOID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([A-Za-z]{2}\-?[A-Za-z0-9]{3}\-?C[A-Za-z0-9]{8}[\*|\-]?[\d|X])|([A-Za-z]{2}[\*|\-]?[A-Za-z0-9]{3}[\*|\-]?[A-Za-z0-9]{6}[\*|\-]?[\d|X])", "%s" given', var_export($eVCOID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($eVCOID) && !is_string($eVCOID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eVCOID)), __LINE__);
        }
        $this->EVCOID = $eVCOID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlugAndChargeIdentificationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
