<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentOptionsList StructType
 * @subpackage Structs
 */
class PaymentOptionsList extends AbstractStructBase
{
    /**
     * The PaymentOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $PaymentOption;
    /**
     * Constructor method for PaymentOptionsList
     * @uses PaymentOptionsList::setPaymentOption()
     * @param string[] $paymentOption
     */
    public function __construct(array $paymentOption = array())
    {
        $this
            ->setPaymentOption($paymentOption);
    }
    /**
     * Get PaymentOption value
     * @return string[]
     */
    public function getPaymentOption()
    {
        return $this->PaymentOption;
    }
    /**
     * Set PaymentOption value
     * @uses \EnumType\PaymentOptionType::valueIsValid()
     * @uses \EnumType\PaymentOptionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $paymentOption
     * @return \StructType\PaymentOptionsList
     */
    public function setPaymentOption(array $paymentOption = array())
    {
        $invalidValues = array();
        foreach ($paymentOption as $paymentOptionsListPaymentOptionItem) {
            if (!\EnumType\PaymentOptionType::valueIsValid($paymentOptionsListPaymentOptionItem)) {
                $invalidValues[] = var_export($paymentOptionsListPaymentOptionItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\PaymentOptionType::getValidValues())), __LINE__);
        }
        $this->PaymentOption = $paymentOption;
        return $this;
    }
    /**
     * Add item to PaymentOption value
     * @uses \EnumType\PaymentOptionType::valueIsValid()
     * @uses \EnumType\PaymentOptionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\PaymentOptionsList
     */
    public function addToPaymentOption($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PaymentOptionType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\PaymentOptionType::getValidValues())), __LINE__);
        }
        $this->PaymentOption[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PaymentOptionsList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
