<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HashType StructType
 * @subpackage Structs
 */
class HashType extends AbstractStructBase
{
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - pattern: [0-9A-Za-z]{10,100}
     * @var string
     */
    public $Value;
    /**
     * The Function
     * @var string
     */
    public $Function;
    /**
     * The Salt
     * Meta informations extracted from the WSDL
     * - maxLength: 100
     * @var string
     */
    public $Salt;
    /**
     * Constructor method for HashType
     * @uses HashType::setValue()
     * @uses HashType::setFunction()
     * @uses HashType::setSalt()
     * @param string $value
     * @param string $function
     * @param string $salt
     */
    public function __construct($value = null, $function = null, $salt = null)
    {
        $this
            ->setValue($value)
            ->setFunction($function)
            ->setSalt($salt);
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\HashType
     */
    public function setValue($value = null)
    {
        // validation for constraint: pattern
        if (is_scalar($value) && !preg_match('/[0-9A-Za-z]{10,100}/', $value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9A-Za-z]{10,100}", "%s" given', var_export($value, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Function value
     * @return string|null
     */
    public function getFunction()
    {
        return $this->Function;
    }
    /**
     * Set Function value
     * @uses \EnumType\HashFunctionType::valueIsValid()
     * @uses \EnumType\HashFunctionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $function
     * @return \StructType\HashType
     */
    public function setFunction($function = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\HashFunctionType::valueIsValid($function)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $function, implode(', ', \EnumType\HashFunctionType::getValidValues())), __LINE__);
        }
        $this->Function = $function;
        return $this;
    }
    /**
     * Get Salt value
     * @return string|null
     */
    public function getSalt()
    {
        return $this->Salt;
    }
    /**
     * Set Salt value
     * @param string $salt
     * @return \StructType\HashType
     */
    public function setSalt($salt = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($salt) && strlen($salt) > 100) || (is_array($salt) && count($salt) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($salt) ? strlen($salt) : count($salt)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($salt) && !is_string($salt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salt)), __LINE__);
        }
        $this->Salt = $salt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HashType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
