<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeoCoordinatesGoogleType StructType
 * @subpackage Structs
 */
class GeoCoordinatesGoogleType extends AbstractStructBase
{
    /**
     * The Coordinates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: -?1?\d{1,2}\.\d{1,6}\s*\,?\s*-?1?\d{1,2}\.\d{1,6}
     * @var string
     */
    public $Coordinates;
    /**
     * Constructor method for GeoCoordinatesGoogleType
     * @uses GeoCoordinatesGoogleType::setCoordinates()
     * @param string $coordinates
     */
    public function __construct($coordinates = null)
    {
        $this
            ->setCoordinates($coordinates);
    }
    /**
     * Get Coordinates value
     * @return string
     */
    public function getCoordinates()
    {
        return $this->Coordinates;
    }
    /**
     * Set Coordinates value
     * @param string $coordinates
     * @return \StructType\GeoCoordinatesGoogleType
     */
    public function setCoordinates($coordinates = null)
    {
        // validation for constraint: pattern
        if (is_scalar($coordinates) && !preg_match('/-?1?\\d{1,2}\\.\\d{1,6}\\s*\\,?\\s*-?1?\\d{1,2}\\.\\d{1,6}/', $coordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "-?1?\d{1,2}\.\d{1,6}\s*\,?\s*-?1?\d{1,2}\.\d{1,6}", "%s" given', var_export($coordinates, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($coordinates) && !is_string($coordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($coordinates)), __LINE__);
        }
        $this->Coordinates = $coordinates;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GeoCoordinatesGoogleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
