<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeoCoordinatesDegreeMinuteSecondsType StructType
 * @subpackage Structs
 */
class GeoCoordinatesDegreeMinuteSecondsType extends AbstractStructBase
{
    /**
     * The Longitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: -?1?\d{1,2}°[ ]?\d{1,2}'[ ]?\d{1,2}\.\d+''
     * @var string
     */
    public $Longitude;
    /**
     * The Latitude
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: -?1?\d{1,2}°[ ]?\d{1,2}'[ ]?\d{1,2}\.\d+''
     * @var string
     */
    public $Latitude;
    /**
     * Constructor method for GeoCoordinatesDegreeMinuteSecondsType
     * @uses GeoCoordinatesDegreeMinuteSecondsType::setLongitude()
     * @uses GeoCoordinatesDegreeMinuteSecondsType::setLatitude()
     * @param string $longitude
     * @param string $latitude
     */
    public function __construct($longitude = null, $latitude = null)
    {
        $this
            ->setLongitude($longitude)
            ->setLatitude($latitude);
    }
    /**
     * Get Longitude value
     * @return string
     */
    public function getLongitude()
    {
        return $this->Longitude;
    }
    /**
     * Set Longitude value
     * @param string $longitude
     * @return \StructType\GeoCoordinatesDegreeMinuteSecondsType
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: pattern
        if (is_scalar($longitude) && !preg_match('/-?1?\\d{1,2}°[ ]?\\d{1,2}\'[ ]?\\d{1,2}\\.\\d+\'\'/', $longitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "-?1?\d{1,2}°[ ]?\d{1,2}\'[ ]?\d{1,2}\.\d+\'\'", "%s" given', var_export($longitude, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($longitude) && !is_string($longitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($longitude)), __LINE__);
        }
        $this->Longitude = $longitude;
        return $this;
    }
    /**
     * Get Latitude value
     * @return string
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param string $latitude
     * @return \StructType\GeoCoordinatesDegreeMinuteSecondsType
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: pattern
        if (is_scalar($latitude) && !preg_match('/-?1?\\d{1,2}°[ ]?\\d{1,2}\'[ ]?\\d{1,2}\\.\\d+\'\'/', $latitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "-?1?\d{1,2}°[ ]?\d{1,2}\'[ ]?\d{1,2}\.\d+\'\'", "%s" given', var_export($latitude, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($latitude) && !is_string($latitude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($latitude)), __LINE__);
        }
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GeoCoordinatesDegreeMinuteSecondsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
