<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EvseDataRecordType StructType
 * @subpackage Structs
 */
class EvseDataRecordType extends AbstractStructBase
{
    /**
     * The EvseId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Za-z]{2}\*?[A-Za-z0-9]{3}\*?E[A-Za-z0-9\*]{1,30})|(\+?[0-9]{1,3}\*[0-9]{3,6}\*[0-9\*]{1,32})
     * @var string
     */
    public $EvseId;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AddressIso19773Type
     */
    public $Address;
    /**
     * The GeoCoordinates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\GeoCoordinatesType
     */
    public $GeoCoordinates;
    /**
     * The Plugs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PlugList
     */
    public $Plugs;
    /**
     * The AuthenticationModes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AuthenticationModeList
     */
    public $AuthenticationModes;
    /**
     * The ValueAddedServices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\ValueAddedServicesList
     */
    public $ValueAddedServices;
    /**
     * The Accessibility
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Accessibility;
    /**
     * The HotlinePhoneNum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: \+[0-9]{5,15}
     * @var string
     */
    public $HotlinePhoneNum;
    /**
     * The IsOpen24Hours
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsOpen24Hours;
    /**
     * The IsHubjectCompatible
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsHubjectCompatible;
    /**
     * The DynamicInfoAvailable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DynamicInfoAvailable;
    /**
     * The ChargingStationId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $ChargingStationId;
    /**
     * The ChargingStationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $ChargingStationName;
    /**
     * The EnChargingStationName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $EnChargingStationName;
    /**
     * The ChargingFacilities
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ChargingFacilityList
     */
    public $ChargingFacilities;
    /**
     * The ChargingModes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ChargingModeList
     */
    public $ChargingModes;
    /**
     * The MaxCapacity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $MaxCapacity;
    /**
     * The PaymentOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentOptionsList
     */
    public $PaymentOptions;
    /**
     * The AdditionalInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 200
     * @var string
     */
    public $AdditionalInfo;
    /**
     * The EnAdditionalInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 2000
     * - pattern: ([A-Z]{3}:.*\|\|\|)+
     * @var string
     */
    public $EnAdditionalInfo;
    /**
     * The GeoChargingPointEntrance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\GeoCoordinatesType
     */
    public $GeoChargingPointEntrance;
    /**
     * The OpeningTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 200
     * @var string
     */
    public $OpeningTime;
    /**
     * The HubOperatorID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: ([A-Za-z]{2}\*?[A-Za-z0-9]{3})|(\+?[0-9]{1,3}\*[0-9]{3,6})
     * @var string
     */
    public $HubOperatorID;
    /**
     * The ClearinghouseID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $ClearinghouseID;
    /**
     * The deltaType
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $deltaType;
    /**
     * The lastUpdate
     * @var string
     */
    public $lastUpdate;
    /**
     * Constructor method for EvseDataRecordType
     * @uses EvseDataRecordType::setEvseId()
     * @uses EvseDataRecordType::setAddress()
     * @uses EvseDataRecordType::setGeoCoordinates()
     * @uses EvseDataRecordType::setPlugs()
     * @uses EvseDataRecordType::setAuthenticationModes()
     * @uses EvseDataRecordType::setValueAddedServices()
     * @uses EvseDataRecordType::setAccessibility()
     * @uses EvseDataRecordType::setHotlinePhoneNum()
     * @uses EvseDataRecordType::setIsOpen24Hours()
     * @uses EvseDataRecordType::setIsHubjectCompatible()
     * @uses EvseDataRecordType::setDynamicInfoAvailable()
     * @uses EvseDataRecordType::setChargingStationId()
     * @uses EvseDataRecordType::setChargingStationName()
     * @uses EvseDataRecordType::setEnChargingStationName()
     * @uses EvseDataRecordType::setChargingFacilities()
     * @uses EvseDataRecordType::setChargingModes()
     * @uses EvseDataRecordType::setMaxCapacity()
     * @uses EvseDataRecordType::setPaymentOptions()
     * @uses EvseDataRecordType::setAdditionalInfo()
     * @uses EvseDataRecordType::setEnAdditionalInfo()
     * @uses EvseDataRecordType::setGeoChargingPointEntrance()
     * @uses EvseDataRecordType::setOpeningTime()
     * @uses EvseDataRecordType::setHubOperatorID()
     * @uses EvseDataRecordType::setClearinghouseID()
     * @uses EvseDataRecordType::setDeltaType()
     * @uses EvseDataRecordType::setLastUpdate()
     * @param string $evseId
     * @param \StructType\AddressIso19773Type $address
     * @param \StructType\GeoCoordinatesType $geoCoordinates
     * @param \StructType\PlugList $plugs
     * @param \StructType\AuthenticationModeList $authenticationModes
     * @param \StructType\ValueAddedServicesList $valueAddedServices
     * @param string $accessibility
     * @param string $hotlinePhoneNum
     * @param bool $isOpen24Hours
     * @param bool $isHubjectCompatible
     * @param string $dynamicInfoAvailable
     * @param string $chargingStationId
     * @param string $chargingStationName
     * @param string $enChargingStationName
     * @param \StructType\ChargingFacilityList $chargingFacilities
     * @param \StructType\ChargingModeList $chargingModes
     * @param int $maxCapacity
     * @param \StructType\PaymentOptionsList $paymentOptions
     * @param string $additionalInfo
     * @param string $enAdditionalInfo
     * @param \StructType\GeoCoordinatesType $geoChargingPointEntrance
     * @param string $openingTime
     * @param string $hubOperatorID
     * @param string $clearinghouseID
     * @param string $deltaType
     * @param string $lastUpdate
     */
    public function __construct($evseId = null, \StructType\AddressIso19773Type $address = null, \StructType\GeoCoordinatesType $geoCoordinates = null, \StructType\PlugList $plugs = null, \StructType\AuthenticationModeList $authenticationModes = null, \StructType\ValueAddedServicesList $valueAddedServices = null, $accessibility = null, $hotlinePhoneNum = null, $isOpen24Hours = null, $isHubjectCompatible = null, $dynamicInfoAvailable = null, $chargingStationId = null, $chargingStationName = null, $enChargingStationName = null, \StructType\ChargingFacilityList $chargingFacilities = null, \StructType\ChargingModeList $chargingModes = null, $maxCapacity = null, \StructType\PaymentOptionsList $paymentOptions = null, $additionalInfo = null, $enAdditionalInfo = null, \StructType\GeoCoordinatesType $geoChargingPointEntrance = null, $openingTime = null, $hubOperatorID = null, $clearinghouseID = null, $deltaType = null, $lastUpdate = null)
    {
        $this
            ->setEvseId($evseId)
            ->setAddress($address)
            ->setGeoCoordinates($geoCoordinates)
            ->setPlugs($plugs)
            ->setAuthenticationModes($authenticationModes)
            ->setValueAddedServices($valueAddedServices)
            ->setAccessibility($accessibility)
            ->setHotlinePhoneNum($hotlinePhoneNum)
            ->setIsOpen24Hours($isOpen24Hours)
            ->setIsHubjectCompatible($isHubjectCompatible)
            ->setDynamicInfoAvailable($dynamicInfoAvailable)
            ->setChargingStationId($chargingStationId)
            ->setChargingStationName($chargingStationName)
            ->setEnChargingStationName($enChargingStationName)
            ->setChargingFacilities($chargingFacilities)
            ->setChargingModes($chargingModes)
            ->setMaxCapacity($maxCapacity)
            ->setPaymentOptions($paymentOptions)
            ->setAdditionalInfo($additionalInfo)
            ->setEnAdditionalInfo($enAdditionalInfo)
            ->setGeoChargingPointEntrance($geoChargingPointEntrance)
            ->setOpeningTime($openingTime)
            ->setHubOperatorID($hubOperatorID)
            ->setClearinghouseID($clearinghouseID)
            ->setDeltaType($deltaType)
            ->setLastUpdate($lastUpdate);
    }
    /**
     * Get EvseId value
     * @return string
     */
    public function getEvseId()
    {
        return $this->EvseId;
    }
    /**
     * Set EvseId value
     * @param string $evseId
     * @return \StructType\EvseDataRecordType
     */
    public function setEvseId($evseId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($evseId) && !preg_match('/([A-Za-z]{2}\\*?[A-Za-z0-9]{3}\\*?E[A-Za-z0-9\\*]{1,30})|(\\+?[0-9]{1,3}\\*[0-9]{3,6}\\*[0-9\\*]{1,32})/', $evseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([A-Za-z]{2}\*?[A-Za-z0-9]{3}\*?E[A-Za-z0-9\*]{1,30})|(\+?[0-9]{1,3}\*[0-9]{3,6}\*[0-9\*]{1,32})", "%s" given', var_export($evseId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($evseId) && !is_string($evseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($evseId)), __LINE__);
        }
        $this->EvseId = $evseId;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\AddressIso19773Type
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\AddressIso19773Type $address
     * @return \StructType\EvseDataRecordType
     */
    public function setAddress(\StructType\AddressIso19773Type $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get GeoCoordinates value
     * @return \StructType\GeoCoordinatesType
     */
    public function getGeoCoordinates()
    {
        return $this->GeoCoordinates;
    }
    /**
     * Set GeoCoordinates value
     * @param \StructType\GeoCoordinatesType $geoCoordinates
     * @return \StructType\EvseDataRecordType
     */
    public function setGeoCoordinates(\StructType\GeoCoordinatesType $geoCoordinates = null)
    {
        $this->GeoCoordinates = $geoCoordinates;
        return $this;
    }
    /**
     * Get Plugs value
     * @return \StructType\PlugList
     */
    public function getPlugs()
    {
        return $this->Plugs;
    }
    /**
     * Set Plugs value
     * @param \StructType\PlugList $plugs
     * @return \StructType\EvseDataRecordType
     */
    public function setPlugs(\StructType\PlugList $plugs = null)
    {
        $this->Plugs = $plugs;
        return $this;
    }
    /**
     * Get AuthenticationModes value
     * @return \StructType\AuthenticationModeList
     */
    public function getAuthenticationModes()
    {
        return $this->AuthenticationModes;
    }
    /**
     * Set AuthenticationModes value
     * @param \StructType\AuthenticationModeList $authenticationModes
     * @return \StructType\EvseDataRecordType
     */
    public function setAuthenticationModes(\StructType\AuthenticationModeList $authenticationModes = null)
    {
        $this->AuthenticationModes = $authenticationModes;
        return $this;
    }
    /**
     * Get ValueAddedServices value
     * @return \StructType\ValueAddedServicesList
     */
    public function getValueAddedServices()
    {
        return $this->ValueAddedServices;
    }
    /**
     * Set ValueAddedServices value
     * @param \StructType\ValueAddedServicesList $valueAddedServices
     * @return \StructType\EvseDataRecordType
     */
    public function setValueAddedServices(\StructType\ValueAddedServicesList $valueAddedServices = null)
    {
        $this->ValueAddedServices = $valueAddedServices;
        return $this;
    }
    /**
     * Get Accessibility value
     * @return string
     */
    public function getAccessibility()
    {
        return $this->Accessibility;
    }
    /**
     * Set Accessibility value
     * @uses \EnumType\AccessibilityType::valueIsValid()
     * @uses \EnumType\AccessibilityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accessibility
     * @return \StructType\EvseDataRecordType
     */
    public function setAccessibility($accessibility = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccessibilityType::valueIsValid($accessibility)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $accessibility, implode(', ', \EnumType\AccessibilityType::getValidValues())), __LINE__);
        }
        $this->Accessibility = $accessibility;
        return $this;
    }
    /**
     * Get HotlinePhoneNum value
     * @return string
     */
    public function getHotlinePhoneNum()
    {
        return $this->HotlinePhoneNum;
    }
    /**
     * Set HotlinePhoneNum value
     * @param string $hotlinePhoneNum
     * @return \StructType\EvseDataRecordType
     */
    public function setHotlinePhoneNum($hotlinePhoneNum = null)
    {
        // validation for constraint: pattern
        if (is_scalar($hotlinePhoneNum) && !preg_match('/\\+[0-9]{5,15}/', $hotlinePhoneNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "\+[0-9]{5,15}", "%s" given', var_export($hotlinePhoneNum, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hotlinePhoneNum) && !is_string($hotlinePhoneNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotlinePhoneNum)), __LINE__);
        }
        $this->HotlinePhoneNum = $hotlinePhoneNum;
        return $this;
    }
    /**
     * Get IsOpen24Hours value
     * @return bool
     */
    public function getIsOpen24Hours()
    {
        return $this->IsOpen24Hours;
    }
    /**
     * Set IsOpen24Hours value
     * @param bool $isOpen24Hours
     * @return \StructType\EvseDataRecordType
     */
    public function setIsOpen24Hours($isOpen24Hours = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOpen24Hours) && !is_bool($isOpen24Hours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isOpen24Hours)), __LINE__);
        }
        $this->IsOpen24Hours = $isOpen24Hours;
        return $this;
    }
    /**
     * Get IsHubjectCompatible value
     * @return bool
     */
    public function getIsHubjectCompatible()
    {
        return $this->IsHubjectCompatible;
    }
    /**
     * Set IsHubjectCompatible value
     * @param bool $isHubjectCompatible
     * @return \StructType\EvseDataRecordType
     */
    public function setIsHubjectCompatible($isHubjectCompatible = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHubjectCompatible) && !is_bool($isHubjectCompatible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isHubjectCompatible)), __LINE__);
        }
        $this->IsHubjectCompatible = $isHubjectCompatible;
        return $this;
    }
    /**
     * Get DynamicInfoAvailable value
     * @return string
     */
    public function getDynamicInfoAvailable()
    {
        return $this->DynamicInfoAvailable;
    }
    /**
     * Set DynamicInfoAvailable value
     * @uses \EnumType\DynamicInfoType::valueIsValid()
     * @uses \EnumType\DynamicInfoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dynamicInfoAvailable
     * @return \StructType\EvseDataRecordType
     */
    public function setDynamicInfoAvailable($dynamicInfoAvailable = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DynamicInfoType::valueIsValid($dynamicInfoAvailable)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $dynamicInfoAvailable, implode(', ', \EnumType\DynamicInfoType::getValidValues())), __LINE__);
        }
        $this->DynamicInfoAvailable = $dynamicInfoAvailable;
        return $this;
    }
    /**
     * Get ChargingStationId value
     * @return string|null
     */
    public function getChargingStationId()
    {
        return $this->ChargingStationId;
    }
    /**
     * Set ChargingStationId value
     * @param string $chargingStationId
     * @return \StructType\EvseDataRecordType
     */
    public function setChargingStationId($chargingStationId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chargingStationId) && strlen($chargingStationId) > 50) || (is_array($chargingStationId) && count($chargingStationId) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($chargingStationId) ? strlen($chargingStationId) : count($chargingStationId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chargingStationId) && !is_string($chargingStationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargingStationId)), __LINE__);
        }
        $this->ChargingStationId = $chargingStationId;
        return $this;
    }
    /**
     * Get ChargingStationName value
     * @return string|null
     */
    public function getChargingStationName()
    {
        return $this->ChargingStationName;
    }
    /**
     * Set ChargingStationName value
     * @param string $chargingStationName
     * @return \StructType\EvseDataRecordType
     */
    public function setChargingStationName($chargingStationName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chargingStationName) && strlen($chargingStationName) > 50) || (is_array($chargingStationName) && count($chargingStationName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($chargingStationName) ? strlen($chargingStationName) : count($chargingStationName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chargingStationName) && !is_string($chargingStationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargingStationName)), __LINE__);
        }
        $this->ChargingStationName = $chargingStationName;
        return $this;
    }
    /**
     * Get EnChargingStationName value
     * @return string|null
     */
    public function getEnChargingStationName()
    {
        return $this->EnChargingStationName;
    }
    /**
     * Set EnChargingStationName value
     * @param string $enChargingStationName
     * @return \StructType\EvseDataRecordType
     */
    public function setEnChargingStationName($enChargingStationName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($enChargingStationName) && strlen($enChargingStationName) > 50) || (is_array($enChargingStationName) && count($enChargingStationName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($enChargingStationName) ? strlen($enChargingStationName) : count($enChargingStationName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enChargingStationName) && !is_string($enChargingStationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enChargingStationName)), __LINE__);
        }
        $this->EnChargingStationName = $enChargingStationName;
        return $this;
    }
    /**
     * Get ChargingFacilities value
     * @return \StructType\ChargingFacilityList|null
     */
    public function getChargingFacilities()
    {
        return $this->ChargingFacilities;
    }
    /**
     * Set ChargingFacilities value
     * @param \StructType\ChargingFacilityList $chargingFacilities
     * @return \StructType\EvseDataRecordType
     */
    public function setChargingFacilities(\StructType\ChargingFacilityList $chargingFacilities = null)
    {
        $this->ChargingFacilities = $chargingFacilities;
        return $this;
    }
    /**
     * Get ChargingModes value
     * @return \StructType\ChargingModeList|null
     */
    public function getChargingModes()
    {
        return $this->ChargingModes;
    }
    /**
     * Set ChargingModes value
     * @param \StructType\ChargingModeList $chargingModes
     * @return \StructType\EvseDataRecordType
     */
    public function setChargingModes(\StructType\ChargingModeList $chargingModes = null)
    {
        $this->ChargingModes = $chargingModes;
        return $this;
    }
    /**
     * Get MaxCapacity value
     * @return int|null
     */
    public function getMaxCapacity()
    {
        return $this->MaxCapacity;
    }
    /**
     * Set MaxCapacity value
     * @param int $maxCapacity
     * @return \StructType\EvseDataRecordType
     */
    public function setMaxCapacity($maxCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($maxCapacity) && !is_numeric($maxCapacity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxCapacity)), __LINE__);
        }
        $this->MaxCapacity = $maxCapacity;
        return $this;
    }
    /**
     * Get PaymentOptions value
     * @return \StructType\PaymentOptionsList|null
     */
    public function getPaymentOptions()
    {
        return $this->PaymentOptions;
    }
    /**
     * Set PaymentOptions value
     * @param \StructType\PaymentOptionsList $paymentOptions
     * @return \StructType\EvseDataRecordType
     */
    public function setPaymentOptions(\StructType\PaymentOptionsList $paymentOptions = null)
    {
        $this->PaymentOptions = $paymentOptions;
        return $this;
    }
    /**
     * Get AdditionalInfo value
     * @return string|null
     */
    public function getAdditionalInfo()
    {
        return $this->AdditionalInfo;
    }
    /**
     * Set AdditionalInfo value
     * @param string $additionalInfo
     * @return \StructType\EvseDataRecordType
     */
    public function setAdditionalInfo($additionalInfo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($additionalInfo) && strlen($additionalInfo) > 200) || (is_array($additionalInfo) && count($additionalInfo) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($additionalInfo) ? strlen($additionalInfo) : count($additionalInfo)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($additionalInfo) && !is_string($additionalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($additionalInfo)), __LINE__);
        }
        $this->AdditionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Get EnAdditionalInfo value
     * @return string|null
     */
    public function getEnAdditionalInfo()
    {
        return $this->EnAdditionalInfo;
    }
    /**
     * Set EnAdditionalInfo value
     * @param string $enAdditionalInfo
     * @return \StructType\EvseDataRecordType
     */
    public function setEnAdditionalInfo($enAdditionalInfo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($enAdditionalInfo) && strlen($enAdditionalInfo) > 2000) || (is_array($enAdditionalInfo) && count($enAdditionalInfo) > 2000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2000 element(s) or a scalar of 2000 character(s) at most, "%d" length given', is_scalar($enAdditionalInfo) ? strlen($enAdditionalInfo) : count($enAdditionalInfo)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($enAdditionalInfo) && !preg_match('/([A-Z]{3}:.*\\|\\|\\|)+/', $enAdditionalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([A-Z]{3}:.*\|\|\|)+", "%s" given', var_export($enAdditionalInfo, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enAdditionalInfo) && !is_string($enAdditionalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enAdditionalInfo)), __LINE__);
        }
        $this->EnAdditionalInfo = $enAdditionalInfo;
        return $this;
    }
    /**
     * Get GeoChargingPointEntrance value
     * @return \StructType\GeoCoordinatesType|null
     */
    public function getGeoChargingPointEntrance()
    {
        return $this->GeoChargingPointEntrance;
    }
    /**
     * Set GeoChargingPointEntrance value
     * @param \StructType\GeoCoordinatesType $geoChargingPointEntrance
     * @return \StructType\EvseDataRecordType
     */
    public function setGeoChargingPointEntrance(\StructType\GeoCoordinatesType $geoChargingPointEntrance = null)
    {
        $this->GeoChargingPointEntrance = $geoChargingPointEntrance;
        return $this;
    }
    /**
     * Get OpeningTime value
     * @return string|null
     */
    public function getOpeningTime()
    {
        return $this->OpeningTime;
    }
    /**
     * Set OpeningTime value
     * @param string $openingTime
     * @return \StructType\EvseDataRecordType
     */
    public function setOpeningTime($openingTime = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($openingTime) && strlen($openingTime) > 200) || (is_array($openingTime) && count($openingTime) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($openingTime) ? strlen($openingTime) : count($openingTime)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($openingTime) && !is_string($openingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($openingTime)), __LINE__);
        }
        $this->OpeningTime = $openingTime;
        return $this;
    }
    /**
     * Get HubOperatorID value
     * @return string|null
     */
    public function getHubOperatorID()
    {
        return $this->HubOperatorID;
    }
    /**
     * Set HubOperatorID value
     * @param string $hubOperatorID
     * @return \StructType\EvseDataRecordType
     */
    public function setHubOperatorID($hubOperatorID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($hubOperatorID) && !preg_match('/([A-Za-z]{2}\\*?[A-Za-z0-9]{3})|(\\+?[0-9]{1,3}\\*[0-9]{3,6})/', $hubOperatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([A-Za-z]{2}\*?[A-Za-z0-9]{3})|(\+?[0-9]{1,3}\*[0-9]{3,6})", "%s" given', var_export($hubOperatorID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hubOperatorID) && !is_string($hubOperatorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hubOperatorID)), __LINE__);
        }
        $this->HubOperatorID = $hubOperatorID;
        return $this;
    }
    /**
     * Get ClearinghouseID value
     * @return string|null
     */
    public function getClearinghouseID()
    {
        return $this->ClearinghouseID;
    }
    /**
     * Set ClearinghouseID value
     * @param string $clearinghouseID
     * @return \StructType\EvseDataRecordType
     */
    public function setClearinghouseID($clearinghouseID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($clearinghouseID) && strlen($clearinghouseID) > 20) || (is_array($clearinghouseID) && count($clearinghouseID) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($clearinghouseID) ? strlen($clearinghouseID) : count($clearinghouseID)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($clearinghouseID) && !is_string($clearinghouseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clearinghouseID)), __LINE__);
        }
        $this->ClearinghouseID = $clearinghouseID;
        return $this;
    }
    /**
     * Get deltaType value
     * @return string|null
     */
    public function getDeltaType()
    {
        return $this->deltaType;
    }
    /**
     * Set deltaType value
     * @param string $deltaType
     * @return \StructType\EvseDataRecordType
     */
    public function setDeltaType($deltaType = null)
    {
        // validation for constraint: string
        if (!is_null($deltaType) && !is_string($deltaType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deltaType)), __LINE__);
        }
        $this->deltaType = $deltaType;
        return $this;
    }
    /**
     * Get lastUpdate value
     * @return string|null
     */
    public function getLastUpdate()
    {
        return $this->lastUpdate;
    }
    /**
     * Set lastUpdate value
     * @param string $lastUpdate
     * @return \StructType\EvseDataRecordType
     */
    public function setLastUpdate($lastUpdate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdate) && !is_string($lastUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdate)), __LINE__);
        }
        $this->lastUpdate = $lastUpdate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EvseDataRecordType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
