<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eRoamingPullEvseData StructType
 * Meta informations extracted from the WSDL
 * - type: tns:eRoamingPullEvseData
 * @subpackage Structs
 */
class ERoamingPullEvseData extends AbstractStructBase
{
    /**
     * The ProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [A-Za-z]{2}[\*|\-]?[A-Za-z0-9]{3}
     * @var string
     */
    public $ProviderID;
    /**
     * The GeoCoordinatesResponseFormat
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GeoCoordinatesResponseFormat;
    /**
     * The SearchCenter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SearchCenterType
     */
    public $SearchCenter;
    /**
     * The LastCall
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastCall;
    /**
     * Constructor method for eRoamingPullEvseData
     * @uses ERoamingPullEvseData::setProviderID()
     * @uses ERoamingPullEvseData::setGeoCoordinatesResponseFormat()
     * @uses ERoamingPullEvseData::setSearchCenter()
     * @uses ERoamingPullEvseData::setLastCall()
     * @param string $providerID
     * @param string $geoCoordinatesResponseFormat
     * @param \StructType\SearchCenterType $searchCenter
     * @param string $lastCall
     */
    public function __construct($providerID = null, $geoCoordinatesResponseFormat = null, \StructType\SearchCenterType $searchCenter = null, $lastCall = null)
    {
        $this
            ->setProviderID($providerID)
            ->setGeoCoordinatesResponseFormat($geoCoordinatesResponseFormat)
            ->setSearchCenter($searchCenter)
            ->setLastCall($lastCall);
    }
    /**
     * Get ProviderID value
     * @return string
     */
    public function getProviderID()
    {
        return $this->ProviderID;
    }
    /**
     * Set ProviderID value
     * @param string $providerID
     * @return \StructType\ERoamingPullEvseData
     */
    public function setProviderID($providerID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($providerID) && !preg_match('/[A-Za-z]{2}[\\*|\\-]?[A-Za-z0-9]{3}/', $providerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z]{2}[\*|\-]?[A-Za-z0-9]{3}", "%s" given', var_export($providerID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($providerID) && !is_string($providerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($providerID)), __LINE__);
        }
        $this->ProviderID = $providerID;
        return $this;
    }
    /**
     * Get GeoCoordinatesResponseFormat value
     * @return string
     */
    public function getGeoCoordinatesResponseFormat()
    {
        return $this->GeoCoordinatesResponseFormat;
    }
    /**
     * Set GeoCoordinatesResponseFormat value
     * @uses \EnumType\GeoCoordinatesResponseFormatType::valueIsValid()
     * @uses \EnumType\GeoCoordinatesResponseFormatType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $geoCoordinatesResponseFormat
     * @return \StructType\ERoamingPullEvseData
     */
    public function setGeoCoordinatesResponseFormat($geoCoordinatesResponseFormat = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GeoCoordinatesResponseFormatType::valueIsValid($geoCoordinatesResponseFormat)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $geoCoordinatesResponseFormat, implode(', ', \EnumType\GeoCoordinatesResponseFormatType::getValidValues())), __LINE__);
        }
        $this->GeoCoordinatesResponseFormat = $geoCoordinatesResponseFormat;
        return $this;
    }
    /**
     * Get SearchCenter value
     * @return \StructType\SearchCenterType|null
     */
    public function getSearchCenter()
    {
        return $this->SearchCenter;
    }
    /**
     * Set SearchCenter value
     * @param \StructType\SearchCenterType $searchCenter
     * @return \StructType\ERoamingPullEvseData
     */
    public function setSearchCenter(\StructType\SearchCenterType $searchCenter = null)
    {
        $this->SearchCenter = $searchCenter;
        return $this;
    }
    /**
     * Get LastCall value
     * @return string|null
     */
    public function getLastCall()
    {
        return $this->LastCall;
    }
    /**
     * Set LastCall value
     * @param string $lastCall
     * @return \StructType\ERoamingPullEvseData
     */
    public function setLastCall($lastCall = null)
    {
        // validation for constraint: string
        if (!is_null($lastCall) && !is_string($lastCall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastCall)), __LINE__);
        }
        $this->LastCall = $lastCall;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ERoamingPullEvseData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
