<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eRoamingAcknowledgement StructType
 * Meta informations extracted from the WSDL
 * - type: tns:eRoamingAcknowledgement
 * @subpackage Structs
 */
class ERoamingAcknowledgement extends AbstractStructBase
{
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var \StructType\StatusCodeType
     */
    public $StatusCode;
    /**
     * The Result
     * @var bool
     */
    public $Result;
    /**
     * The SessionID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: [A-Za-z0-9]{8}(-[A-Za-z0-9]{4}){3}-[A-Za-z0-9]{12}
     * @var string
     */
    public $SessionID;
    /**
     * The PartnerSessionID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $PartnerSessionID;
    /**
     * Constructor method for eRoamingAcknowledgement
     * @uses ERoamingAcknowledgement::setStatusCode()
     * @uses ERoamingAcknowledgement::setResult()
     * @uses ERoamingAcknowledgement::setSessionID()
     * @uses ERoamingAcknowledgement::setPartnerSessionID()
     * @param \StructType\StatusCodeType $statusCode
     * @param bool $result
     * @param string $sessionID
     * @param string $partnerSessionID
     */
    public function __construct(\StructType\StatusCodeType $statusCode = null, $result = null, $sessionID = null, $partnerSessionID = null)
    {
        $this
            ->setStatusCode($statusCode)
            ->setResult($result)
            ->setSessionID($sessionID)
            ->setPartnerSessionID($partnerSessionID);
    }
    /**
     * Get StatusCode value
     * @return \StructType\StatusCodeType
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param \StructType\StatusCodeType $statusCode
     * @return \StructType\ERoamingAcknowledgement
     */
    public function setStatusCode(\StructType\StatusCodeType $statusCode = null)
    {
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get Result value
     * @return bool|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param bool $result
     * @return \StructType\ERoamingAcknowledgement
     */
    public function setResult($result = null)
    {
        // validation for constraint: boolean
        if (!is_null($result) && !is_bool($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Get SessionID value
     * @return string|null
     */
    public function getSessionID()
    {
        return $this->SessionID;
    }
    /**
     * Set SessionID value
     * @param string $sessionID
     * @return \StructType\ERoamingAcknowledgement
     */
    public function setSessionID($sessionID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($sessionID) && !preg_match('/[A-Za-z0-9]{8}(-[A-Za-z0-9]{4}){3}-[A-Za-z0-9]{12}/', $sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Za-z0-9]{8}(-[A-Za-z0-9]{4}){3}-[A-Za-z0-9]{12}", "%s" given', var_export($sessionID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sessionID) && !is_string($sessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sessionID)), __LINE__);
        }
        $this->SessionID = $sessionID;
        return $this;
    }
    /**
     * Get PartnerSessionID value
     * @return string|null
     */
    public function getPartnerSessionID()
    {
        return $this->PartnerSessionID;
    }
    /**
     * Set PartnerSessionID value
     * @param string $partnerSessionID
     * @return \StructType\ERoamingAcknowledgement
     */
    public function setPartnerSessionID($partnerSessionID = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($partnerSessionID) && strlen($partnerSessionID) > 50) || (is_array($partnerSessionID) && count($partnerSessionID) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($partnerSessionID) ? strlen($partnerSessionID) : count($partnerSessionID)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($partnerSessionID) && !is_string($partnerSessionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partnerSessionID)), __LINE__);
        }
        $this->PartnerSessionID = $partnerSessionID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ERoamingAcknowledgement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
