<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChargingModeList StructType
 * @subpackage Structs
 */
class ChargingModeList extends AbstractStructBase
{
    /**
     * The ChargingMode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $ChargingMode;
    /**
     * Constructor method for ChargingModeList
     * @uses ChargingModeList::setChargingMode()
     * @param string[] $chargingMode
     */
    public function __construct(array $chargingMode = array())
    {
        $this
            ->setChargingMode($chargingMode);
    }
    /**
     * Get ChargingMode value
     * @return string[]
     */
    public function getChargingMode()
    {
        return $this->ChargingMode;
    }
    /**
     * Set ChargingMode value
     * @uses \EnumType\ChargingModeType::valueIsValid()
     * @uses \EnumType\ChargingModeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $chargingMode
     * @return \StructType\ChargingModeList
     */
    public function setChargingMode(array $chargingMode = array())
    {
        $invalidValues = array();
        foreach ($chargingMode as $chargingModeListChargingModeItem) {
            if (!\EnumType\ChargingModeType::valueIsValid($chargingModeListChargingModeItem)) {
                $invalidValues[] = var_export($chargingModeListChargingModeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\ChargingModeType::getValidValues())), __LINE__);
        }
        $this->ChargingMode = $chargingMode;
        return $this;
    }
    /**
     * Add item to ChargingMode value
     * @uses \EnumType\ChargingModeType::valueIsValid()
     * @uses \EnumType\ChargingModeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ChargingModeList
     */
    public function addToChargingMode($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ChargingModeType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\ChargingModeType::getValidValues())), __LINE__);
        }
        $this->ChargingMode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ChargingModeList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
