<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressIso19773Type StructType
 * @subpackage Structs
 */
class AddressIso19773Type extends AbstractStructBase
{
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Country;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $City;
    /**
     * The Street
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 100
     * - minLength: 5
     * @var string
     */
    public $Street;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 10
     * @var string
     */
    public $PostalCode;
    /**
     * The HouseNum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 10
     * @var string
     */
    public $HouseNum;
    /**
     * The Floor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 5
     * @var string
     */
    public $Floor;
    /**
     * The Region
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 50
     * @var string
     */
    public $Region;
    /**
     * The TimeZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 10
     * @var string
     */
    public $TimeZone;
    /**
     * Constructor method for AddressIso19773Type
     * @uses AddressIso19773Type::setCountry()
     * @uses AddressIso19773Type::setCity()
     * @uses AddressIso19773Type::setStreet()
     * @uses AddressIso19773Type::setPostalCode()
     * @uses AddressIso19773Type::setHouseNum()
     * @uses AddressIso19773Type::setFloor()
     * @uses AddressIso19773Type::setRegion()
     * @uses AddressIso19773Type::setTimeZone()
     * @param string $country
     * @param string $city
     * @param string $street
     * @param string $postalCode
     * @param string $houseNum
     * @param string $floor
     * @param string $region
     * @param string $timeZone
     */
    public function __construct($country = null, $city = null, $street = null, $postalCode = null, $houseNum = null, $floor = null, $region = null, $timeZone = null)
    {
        $this
            ->setCountry($country)
            ->setCity($city)
            ->setStreet($street)
            ->setPostalCode($postalCode)
            ->setHouseNum($houseNum)
            ->setFloor($floor)
            ->setRegion($region)
            ->setTimeZone($timeZone);
    }
    /**
     * Get Country value
     * @return string
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @uses \EnumType\CountryCodeType::valueIsValid()
     * @uses \EnumType\CountryCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $country
     * @return \StructType\AddressIso19773Type
     */
    public function setCountry($country = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CountryCodeType::valueIsValid($country)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $country, implode(', ', \EnumType\CountryCodeType::getValidValues())), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get City value
     * @return string
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \StructType\AddressIso19773Type
     */
    public function setCity($city = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($city) && strlen($city) > 50) || (is_array($city) && count($city) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($city) ? strlen($city) : count($city)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($city) && strlen($city) < 1) || (is_array($city) && count($city) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get Street value
     * @return string
     */
    public function getStreet()
    {
        return $this->Street;
    }
    /**
     * Set Street value
     * @param string $street
     * @return \StructType\AddressIso19773Type
     */
    public function setStreet($street = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($street) && strlen($street) > 100) || (is_array($street) && count($street) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($street) ? strlen($street) : count($street)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($street) && strlen($street) < 5) || (is_array($street) && count($street) < 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($street)), __LINE__);
        }
        $this->Street = $street;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\AddressIso19773Type
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postalCode) && strlen($postalCode) > 10) || (is_array($postalCode) && count($postalCode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($postalCode) ? strlen($postalCode) : count($postalCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get HouseNum value
     * @return string|null
     */
    public function getHouseNum()
    {
        return $this->HouseNum;
    }
    /**
     * Set HouseNum value
     * @param string $houseNum
     * @return \StructType\AddressIso19773Type
     */
    public function setHouseNum($houseNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($houseNum) && strlen($houseNum) > 10) || (is_array($houseNum) && count($houseNum) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($houseNum) ? strlen($houseNum) : count($houseNum)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($houseNum) && !is_string($houseNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($houseNum)), __LINE__);
        }
        $this->HouseNum = $houseNum;
        return $this;
    }
    /**
     * Get Floor value
     * @return string|null
     */
    public function getFloor()
    {
        return $this->Floor;
    }
    /**
     * Set Floor value
     * @param string $floor
     * @return \StructType\AddressIso19773Type
     */
    public function setFloor($floor = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($floor) && strlen($floor) > 5) || (is_array($floor) && count($floor) > 5)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s) at most, "%d" length given', is_scalar($floor) ? strlen($floor) : count($floor)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($floor) && !is_string($floor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($floor)), __LINE__);
        }
        $this->Floor = $floor;
        return $this;
    }
    /**
     * Get Region value
     * @return string|null
     */
    public function getRegion()
    {
        return $this->Region;
    }
    /**
     * Set Region value
     * @param string $region
     * @return \StructType\AddressIso19773Type
     */
    public function setRegion($region = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($region) && strlen($region) > 50) || (is_array($region) && count($region) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($region) ? strlen($region) : count($region)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($region)), __LINE__);
        }
        $this->Region = $region;
        return $this;
    }
    /**
     * Get TimeZone value
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->TimeZone;
    }
    /**
     * Set TimeZone value
     * @param string $timeZone
     * @return \StructType\AddressIso19773Type
     */
    public function setTimeZone($timeZone = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($timeZone) && strlen($timeZone) > 10) || (is_array($timeZone) && count($timeZone) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($timeZone) ? strlen($timeZone) : count($timeZone)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($timeZone) && !is_string($timeZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeZone)), __LINE__);
        }
        $this->TimeZone = $timeZone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressIso19773Type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
