<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for ER ServiceType
 * @subpackage Services
 */
class ER extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named eRoamingPushEvseData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ERoamingPushEvseData $parameters
     * @return \StructType\ERoamingAcknowledgement|bool
     */
    public function eRoamingPushEvseData(\StructType\ERoamingPushEvseData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->eRoamingPushEvseData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named eRoamingPullEvseData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ERoamingPullEvseData $parameters
     * @return \StructType\ERoamingEvseData|bool
     */
    public function eRoamingPullEvseData(\StructType\ERoamingPullEvseData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->eRoamingPullEvseData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named eRoamingGetEvseById
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ERoamingGetEvseById $parameters
     * @return \StructType\EvseDataRecordType|bool
     */
    public function eRoamingGetEvseById(\StructType\ERoamingGetEvseById $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->eRoamingGetEvseById($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ERoamingAcknowledgement|\StructType\ERoamingEvseData|\StructType\EvseDataRecordType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
