<?php

namespace EnumType;

/**
 * This class stands for ValueAddedServiceType EnumType
 * @subpackage Enumerations
 */
class ValueAddedServiceType
{
    /**
     * Constant for value 'Reservation'
     * @return string 'Reservation'
     */
    const VALUE_RESERVATION = 'Reservation';
    /**
     * Constant for value 'DynamicPricing'
     * @return string 'DynamicPricing'
     */
    const VALUE_DYNAMIC_PRICING = 'DynamicPricing';
    /**
     * Constant for value 'ParkingSensors'
     * @return string 'ParkingSensors'
     */
    const VALUE_PARKING_SENSORS = 'ParkingSensors';
    /**
     * Constant for value 'MaximumPowerCharging'
     * @return string 'MaximumPowerCharging'
     */
    const VALUE_MAXIMUM_POWER_CHARGING = 'MaximumPowerCharging';
    /**
     * Constant for value 'PredictiveChargePointUsage'
     * @return string 'PredictiveChargePointUsage'
     */
    const VALUE_PREDICTIVE_CHARGE_POINT_USAGE = 'PredictiveChargePointUsage';
    /**
     * Constant for value 'ChargingPlans'
     * @return string 'ChargingPlans'
     */
    const VALUE_CHARGING_PLANS = 'ChargingPlans';
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RESERVATION
     * @uses self::VALUE_DYNAMIC_PRICING
     * @uses self::VALUE_PARKING_SENSORS
     * @uses self::VALUE_MAXIMUM_POWER_CHARGING
     * @uses self::VALUE_PREDICTIVE_CHARGE_POINT_USAGE
     * @uses self::VALUE_CHARGING_PLANS
     * @uses self::VALUE_NONE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RESERVATION,
            self::VALUE_DYNAMIC_PRICING,
            self::VALUE_PARKING_SENSORS,
            self::VALUE_MAXIMUM_POWER_CHARGING,
            self::VALUE_PREDICTIVE_CHARGE_POINT_USAGE,
            self::VALUE_CHARGING_PLANS,
            self::VALUE_NONE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
