<?php

namespace EnumType;

/**
 * This class stands for TimePeriod EnumType
 * @subpackage Enumerations
 */
class TimePeriod
{
    /**
     * Constant for value 'DAY'
     * @return string 'DAY'
     */
    const VALUE_DAY = 'DAY';
    /**
     * Constant for value 'MONTH'
     * @return string 'MONTH'
     */
    const VALUE_MONTH = 'MONTH';
    /**
     * Constant for value 'YEAR'
     * @return string 'YEAR'
     */
    const VALUE_YEAR = 'YEAR';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DAY
     * @uses self::VALUE_MONTH
     * @uses self::VALUE_YEAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DAY,
            self::VALUE_MONTH,
            self::VALUE_YEAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
