<?php

namespace EnumType;

/**
 * This class stands for PlugType EnumType
 * @subpackage Enumerations
 */
class PlugType
{
    /**
     * Constant for value 'Small Paddle Inductive'
     * @return string 'Small Paddle Inductive'
     */
    const VALUE_SMALL_PADDLE_INDUCTIVE = 'Small Paddle Inductive';
    /**
     * Constant for value 'Large Paddle Inductive'
     * @return string 'Large Paddle Inductive'
     */
    const VALUE_LARGE_PADDLE_INDUCTIVE = 'Large Paddle Inductive';
    /**
     * Constant for value 'AVCON Connector'
     * @return string 'AVCON Connector'
     */
    const VALUE_AVCON_CONNECTOR = 'AVCON Connector';
    /**
     * Constant for value 'Tesla Connector'
     * @return string 'Tesla Connector'
     */
    const VALUE_TESLA_CONNECTOR = 'Tesla Connector';
    /**
     * Constant for value 'NEMA 5-20'
     * @return string 'NEMA 5-20'
     */
    const VALUE_NEMA_5_20 = 'NEMA 5-20';
    /**
     * Constant for value 'Type E French Standard'
     * @return string 'Type E French Standard'
     */
    const VALUE_TYPE_E_FRENCH_STANDARD = 'Type E French Standard';
    /**
     * Constant for value 'Type F Schuko'
     * @return string 'Type F Schuko'
     */
    const VALUE_TYPE_F_SCHUKO = 'Type F Schuko';
    /**
     * Constant for value 'Type G British Standard'
     * @return string 'Type G British Standard'
     */
    const VALUE_TYPE_G_BRITISH_STANDARD = 'Type G British Standard';
    /**
     * Constant for value 'Type J Swiss Standard'
     * @return string 'Type J Swiss Standard'
     */
    const VALUE_TYPE_J_SWISS_STANDARD = 'Type J Swiss Standard';
    /**
     * Constant for value 'Type 1 Connector (Cable Attached)'
     * @return string 'Type 1 Connector (Cable Attached)'
     */
    const VALUE_TYPE_1_CONNECTOR_CABLE_ATTACHED = 'Type 1 Connector (Cable Attached)';
    /**
     * Constant for value 'Type 2 Outlet'
     * @return string 'Type 2 Outlet'
     */
    const VALUE_TYPE_2_OUTLET = 'Type 2 Outlet';
    /**
     * Constant for value 'Type 2 Connector (Cable Attached)'
     * @return string 'Type 2 Connector (Cable Attached)'
     */
    const VALUE_TYPE_2_CONNECTOR_CABLE_ATTACHED = 'Type 2 Connector (Cable Attached)';
    /**
     * Constant for value 'Type 3 Outlet'
     * @return string 'Type 3 Outlet'
     */
    const VALUE_TYPE_3_OUTLET = 'Type 3 Outlet';
    /**
     * Constant for value 'IEC 60309 Single Phase'
     * @return string 'IEC 60309 Single Phase'
     */
    const VALUE_IEC_60309_SINGLE_PHASE = 'IEC 60309 Single Phase';
    /**
     * Constant for value 'IEC 60309 Three Phase'
     * @return string 'IEC 60309 Three Phase'
     */
    const VALUE_IEC_60309_THREE_PHASE = 'IEC 60309 Three Phase';
    /**
     * Constant for value 'CCS Combo 2 Plug (Cable Attached)'
     * @return string 'CCS Combo 2 Plug (Cable Attached)'
     */
    const VALUE_CCS_COMBO_2_PLUG_CABLE_ATTACHED = 'CCS Combo 2 Plug (Cable Attached)';
    /**
     * Constant for value 'CCS Combo 1 Plug (Cable Attached)'
     * @return string 'CCS Combo 1 Plug (Cable Attached)'
     */
    const VALUE_CCS_COMBO_1_PLUG_CABLE_ATTACHED = 'CCS Combo 1 Plug (Cable Attached)';
    /**
     * Constant for value 'CHAdeMO'
     * @return string 'CHAdeMO'
     */
    const VALUE_CHADE_MO = 'CHAdeMO';
    /**
     * Constant for value 'Unspecified'
     * @return string 'Unspecified'
     */
    const VALUE_UNSPECIFIED = 'Unspecified';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SMALL_PADDLE_INDUCTIVE
     * @uses self::VALUE_LARGE_PADDLE_INDUCTIVE
     * @uses self::VALUE_AVCON_CONNECTOR
     * @uses self::VALUE_TESLA_CONNECTOR
     * @uses self::VALUE_NEMA_5_20
     * @uses self::VALUE_TYPE_E_FRENCH_STANDARD
     * @uses self::VALUE_TYPE_F_SCHUKO
     * @uses self::VALUE_TYPE_G_BRITISH_STANDARD
     * @uses self::VALUE_TYPE_J_SWISS_STANDARD
     * @uses self::VALUE_TYPE_1_CONNECTOR_CABLE_ATTACHED
     * @uses self::VALUE_TYPE_2_OUTLET
     * @uses self::VALUE_TYPE_2_CONNECTOR_CABLE_ATTACHED
     * @uses self::VALUE_TYPE_3_OUTLET
     * @uses self::VALUE_IEC_60309_SINGLE_PHASE
     * @uses self::VALUE_IEC_60309_THREE_PHASE
     * @uses self::VALUE_CCS_COMBO_2_PLUG_CABLE_ATTACHED
     * @uses self::VALUE_CCS_COMBO_1_PLUG_CABLE_ATTACHED
     * @uses self::VALUE_CHADE_MO
     * @uses self::VALUE_UNSPECIFIED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SMALL_PADDLE_INDUCTIVE,
            self::VALUE_LARGE_PADDLE_INDUCTIVE,
            self::VALUE_AVCON_CONNECTOR,
            self::VALUE_TESLA_CONNECTOR,
            self::VALUE_NEMA_5_20,
            self::VALUE_TYPE_E_FRENCH_STANDARD,
            self::VALUE_TYPE_F_SCHUKO,
            self::VALUE_TYPE_G_BRITISH_STANDARD,
            self::VALUE_TYPE_J_SWISS_STANDARD,
            self::VALUE_TYPE_1_CONNECTOR_CABLE_ATTACHED,
            self::VALUE_TYPE_2_OUTLET,
            self::VALUE_TYPE_2_CONNECTOR_CABLE_ATTACHED,
            self::VALUE_TYPE_3_OUTLET,
            self::VALUE_IEC_60309_SINGLE_PHASE,
            self::VALUE_IEC_60309_THREE_PHASE,
            self::VALUE_CCS_COMBO_2_PLUG_CABLE_ATTACHED,
            self::VALUE_CCS_COMBO_1_PLUG_CABLE_ATTACHED,
            self::VALUE_CHADE_MO,
            self::VALUE_UNSPECIFIED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
