<?php

namespace EnumType;

/**
 * This class stands for PaymentOptionType EnumType
 * @subpackage Enumerations
 */
class PaymentOptionType
{
    /**
     * Constant for value 'No Payment'
     * @return string 'No Payment'
     */
    const VALUE_NO_PAYMENT = 'No Payment';
    /**
     * Constant for value 'Direct'
     * @return string 'Direct'
     */
    const VALUE_DIRECT = 'Direct';
    /**
     * Constant for value 'Contract'
     * @return string 'Contract'
     */
    const VALUE_CONTRACT = 'Contract';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO_PAYMENT
     * @uses self::VALUE_DIRECT
     * @uses self::VALUE_CONTRACT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO_PAYMENT,
            self::VALUE_DIRECT,
            self::VALUE_CONTRACT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
