<?php

namespace EnumType;

/**
 * This class stands for DynamicInfoType EnumType
 * @subpackage Enumerations
 */
class DynamicInfoType
{
    /**
     * Constant for value 'true'
     * @return string 'true'
     */
    const VALUE_TRUE = 'true';
    /**
     * Constant for value 'false'
     * @return string 'false'
     */
    const VALUE_FALSE = 'false';
    /**
     * Constant for value 'auto'
     * @return string 'auto'
     */
    const VALUE_AUTO = 'auto';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TRUE
     * @uses self::VALUE_FALSE
     * @uses self::VALUE_AUTO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TRUE,
            self::VALUE_FALSE,
            self::VALUE_AUTO,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
