<?php

namespace EnumType;

/**
 * This class stands for ChargingFacilityType EnumType
 * @subpackage Enumerations
 */
class ChargingFacilityType
{
    /**
     * Constant for value '100 - 120V, 1-Phase ≤10A'
     * @return string '100 - 120V, 1-Phase ≤10A'
     */
    const VALUE_100_120_V_1_PHASE_10_A = '100 - 120V, 1-Phase ≤10A';
    /**
     * Constant for value '100 - 120V, 1-Phase ≤16A'
     * @return string '100 - 120V, 1-Phase ≤16A'
     */
    const VALUE_100_120_V_1_PHASE_16_A = '100 - 120V, 1-Phase ≤16A';
    /**
     * Constant for value '100 - 120V, 1-Phase ≤32A'
     * @return string '100 - 120V, 1-Phase ≤32A'
     */
    const VALUE_100_120_V_1_PHASE_32_A = '100 - 120V, 1-Phase ≤32A';
    /**
     * Constant for value '200 - 240V, 1-Phase ≤10A'
     * @return string '200 - 240V, 1-Phase ≤10A'
     */
    const VALUE_200_240_V_1_PHASE_10_A = '200 - 240V, 1-Phase ≤10A';
    /**
     * Constant for value '200 - 240V, 1-Phase ≤16A'
     * @return string '200 - 240V, 1-Phase ≤16A'
     */
    const VALUE_200_240_V_1_PHASE_16_A = '200 - 240V, 1-Phase ≤16A';
    /**
     * Constant for value '200 - 240V, 1-Phase ≤32A'
     * @return string '200 - 240V, 1-Phase ≤32A'
     */
    const VALUE_200_240_V_1_PHASE_32_A = '200 - 240V, 1-Phase ≤32A';
    /**
     * Constant for value '200 - 240V, 1-Phase >32A'
     * @return string '200 - 240V, 1-Phase >32A'
     */
    const VALUE_200_240_V_1_PHASE_32_A_1 = '200 - 240V, 1-Phase >32A';
    /**
     * Constant for value '380 - 480V, 3-Phase ≤16A'
     * @return string '380 - 480V, 3-Phase ≤16A'
     */
    const VALUE_380_480_V_3_PHASE_16_A = '380 - 480V, 3-Phase ≤16A';
    /**
     * Constant for value '380 - 480V, 3-Phase ≤32A'
     * @return string '380 - 480V, 3-Phase ≤32A'
     */
    const VALUE_380_480_V_3_PHASE_32_A = '380 - 480V, 3-Phase ≤32A';
    /**
     * Constant for value '380 - 480V, 3-Phase ≤63A'
     * @return string '380 - 480V, 3-Phase ≤63A'
     */
    const VALUE_380_480_V_3_PHASE_63_A = '380 - 480V, 3-Phase ≤63A';
    /**
     * Constant for value 'Battery exchange'
     * @return string 'Battery exchange'
     */
    const VALUE_BATTERY_EXCHANGE = 'Battery exchange';
    /**
     * Constant for value 'DC Charging ≤20kW'
     * @return string 'DC Charging ≤20kW'
     */
    const VALUE_DC_CHARGING_20_K_W = 'DC Charging ≤20kW';
    /**
     * Constant for value 'DC Charging ≤50kW'
     * @return string 'DC Charging ≤50kW'
     */
    const VALUE_DC_CHARGING_50_K_W = 'DC Charging ≤50kW';
    /**
     * Constant for value 'DC Charging >50kW'
     * @return string 'DC Charging >50kW'
     */
    const VALUE_DC_CHARGING_50_K_W_1 = 'DC Charging >50kW';
    /**
     * Constant for value 'Unspecified'
     * @return string 'Unspecified'
     */
    const VALUE_UNSPECIFIED = 'Unspecified';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_100_120_V_1_PHASE_10_A
     * @uses self::VALUE_100_120_V_1_PHASE_16_A
     * @uses self::VALUE_100_120_V_1_PHASE_32_A
     * @uses self::VALUE_200_240_V_1_PHASE_10_A
     * @uses self::VALUE_200_240_V_1_PHASE_16_A
     * @uses self::VALUE_200_240_V_1_PHASE_32_A
     * @uses self::VALUE_200_240_V_1_PHASE_32_A_1
     * @uses self::VALUE_380_480_V_3_PHASE_16_A
     * @uses self::VALUE_380_480_V_3_PHASE_32_A
     * @uses self::VALUE_380_480_V_3_PHASE_63_A
     * @uses self::VALUE_BATTERY_EXCHANGE
     * @uses self::VALUE_DC_CHARGING_20_K_W
     * @uses self::VALUE_DC_CHARGING_50_K_W
     * @uses self::VALUE_DC_CHARGING_50_K_W_1
     * @uses self::VALUE_UNSPECIFIED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_100_120_V_1_PHASE_10_A,
            self::VALUE_100_120_V_1_PHASE_16_A,
            self::VALUE_100_120_V_1_PHASE_32_A,
            self::VALUE_200_240_V_1_PHASE_10_A,
            self::VALUE_200_240_V_1_PHASE_16_A,
            self::VALUE_200_240_V_1_PHASE_32_A,
            self::VALUE_200_240_V_1_PHASE_32_A_1,
            self::VALUE_380_480_V_3_PHASE_16_A,
            self::VALUE_380_480_V_3_PHASE_32_A,
            self::VALUE_380_480_V_3_PHASE_63_A,
            self::VALUE_BATTERY_EXCHANGE,
            self::VALUE_DC_CHARGING_20_K_W,
            self::VALUE_DC_CHARGING_50_K_W,
            self::VALUE_DC_CHARGING_50_K_W_1,
            self::VALUE_UNSPECIFIED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
