<?php

namespace EnumType;

/**
 * This class stands for AuthorizationStatusType EnumType
 * @subpackage Enumerations
 */
class AuthorizationStatusType
{
    /**
     * Constant for value 'Authorized'
     * @return string 'Authorized'
     */
    const VALUE_AUTHORIZED = 'Authorized';
    /**
     * Constant for value 'NotAuthorized'
     * @return string 'NotAuthorized'
     */
    const VALUE_NOT_AUTHORIZED = 'NotAuthorized';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AUTHORIZED
     * @uses self::VALUE_NOT_AUTHORIZED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AUTHORIZED,
            self::VALUE_NOT_AUTHORIZED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
