<?php

namespace EnumType;

/**
 * This class stands for ActionType EnumType
 * @subpackage Enumerations
 */
class ActionType
{
    /**
     * Constant for value 'fullLoad'
     * @return string 'fullLoad'
     */
    const VALUE_FULL_LOAD = 'fullLoad';
    /**
     * Constant for value 'update'
     * @return string 'update'
     */
    const VALUE_UPDATE = 'update';
    /**
     * Constant for value 'insert'
     * @return string 'insert'
     */
    const VALUE_INSERT = 'insert';
    /**
     * Constant for value 'delete'
     * @return string 'delete'
     */
    const VALUE_DELETE = 'delete';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FULL_LOAD
     * @uses self::VALUE_UPDATE
     * @uses self::VALUE_INSERT
     * @uses self::VALUE_DELETE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FULL_LOAD,
            self::VALUE_UPDATE,
            self::VALUE_INSERT,
            self::VALUE_DELETE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
