<?php

namespace EnumType;

/**
 * This class stands for AccessibilityType EnumType
 * @subpackage Enumerations
 */
class AccessibilityType
{
    /**
     * Constant for value 'Unspecified'
     * @return string 'Unspecified'
     */
    const VALUE_UNSPECIFIED = 'Unspecified';
    /**
     * Constant for value 'Free publicly accessible'
     * @return string 'Free publicly accessible'
     */
    const VALUE_FREE_PUBLICLY_ACCESSIBLE = 'Free publicly accessible';
    /**
     * Constant for value 'Restricted access'
     * @return string 'Restricted access'
     */
    const VALUE_RESTRICTED_ACCESS = 'Restricted access';
    /**
     * Constant for value 'Paying publicly accessible'
     * @return string 'Paying publicly accessible'
     */
    const VALUE_PAYING_PUBLICLY_ACCESSIBLE = 'Paying publicly accessible';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNSPECIFIED
     * @uses self::VALUE_FREE_PUBLICLY_ACCESSIBLE
     * @uses self::VALUE_RESTRICTED_ACCESS
     * @uses self::VALUE_PAYING_PUBLICLY_ACCESSIBLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNSPECIFIED,
            self::VALUE_FREE_PUBLICLY_ACCESSIBLE,
            self::VALUE_RESTRICTED_ACCESS,
            self::VALUE_PAYING_PUBLICLY_ACCESSIBLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
