<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatusCodeType StructType
 * @subpackage Structs
 */
class StatusCodeType extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 200
     * @var string
     */
    public $Description;
    /**
     * The AdditionalInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1000
     * @var string
     */
    public $AdditionalInfo;
    /**
     * Constructor method for StatusCodeType
     * @uses StatusCodeType::setCode()
     * @uses StatusCodeType::setDescription()
     * @uses StatusCodeType::setAdditionalInfo()
     * @param string $code
     * @param string $description
     * @param string $additionalInfo
     */
    public function __construct($code = null, $description = null, $additionalInfo = null)
    {
        $this
            ->setCode($code)
            ->setDescription($description)
            ->setAdditionalInfo($additionalInfo);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @uses \EnumType\CodeType::valueIsValid()
     * @uses \EnumType\CodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $code
     * @return \StructType\StatusCodeType
     */
    public function setCode($code = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CodeType::valueIsValid($code)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $code, implode(', ', \EnumType\CodeType::getValidValues())), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\StatusCodeType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 200) || (is_array($description) && count($description) > 200)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 200 element(s) or a scalar of 200 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get AdditionalInfo value
     * @return string|null
     */
    public function getAdditionalInfo()
    {
        return $this->AdditionalInfo;
    }
    /**
     * Set AdditionalInfo value
     * @param string $additionalInfo
     * @return \StructType\StatusCodeType
     */
    public function setAdditionalInfo($additionalInfo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($additionalInfo) && strlen($additionalInfo) > 1000) || (is_array($additionalInfo) && count($additionalInfo) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($additionalInfo) ? strlen($additionalInfo) : count($additionalInfo)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($additionalInfo) && !is_string($additionalInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($additionalInfo)), __LINE__);
        }
        $this->AdditionalInfo = $additionalInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StatusCodeType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
