<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SearchCenterType StructType
 * @subpackage Structs
 */
class SearchCenterType extends AbstractStructBase
{
    /**
     * The GeoCoordinates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\GeoCoordinatesType
     */
    public $GeoCoordinates;
    /**
     * The Radius
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Radius;
    /**
     * Constructor method for SearchCenterType
     * @uses SearchCenterType::setGeoCoordinates()
     * @uses SearchCenterType::setRadius()
     * @param \StructType\GeoCoordinatesType $geoCoordinates
     * @param string $radius
     */
    public function __construct(\StructType\GeoCoordinatesType $geoCoordinates = null, $radius = null)
    {
        $this
            ->setGeoCoordinates($geoCoordinates)
            ->setRadius($radius);
    }
    /**
     * Get GeoCoordinates value
     * @return \StructType\GeoCoordinatesType
     */
    public function getGeoCoordinates()
    {
        return $this->GeoCoordinates;
    }
    /**
     * Set GeoCoordinates value
     * @param \StructType\GeoCoordinatesType $geoCoordinates
     * @return \StructType\SearchCenterType
     */
    public function setGeoCoordinates(\StructType\GeoCoordinatesType $geoCoordinates = null)
    {
        $this->GeoCoordinates = $geoCoordinates;
        return $this;
    }
    /**
     * Get Radius value
     * @return string
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param string $radius
     * @return \StructType\SearchCenterType
     */
    public function setRadius($radius = null)
    {
        // validation for constraint: string
        if (!is_null($radius) && !is_string($radius)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($radius)), __LINE__);
        }
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SearchCenterType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
