<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QRCodeIdentificationType StructType
 * @subpackage Structs
 */
class QRCodeIdentificationType extends AbstractStructBase
{
    /**
     * The EVCOID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: ([A-Za-z]{2}\-?[A-Za-z0-9]{3}\-?C[A-Za-z0-9]{8}[\*|\-]?[\d|X])|([A-Za-z]{2}[\*|\-]?[A-Za-z0-9]{3}[\*|\-]?[A-Za-z0-9]{6}[\*|\-]?[\d|X])
     * @var string
     */
    public $EVCOID;
    /**
     * The PIN
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 20
     * @var string
     */
    public $PIN;
    /**
     * The HashedPIN
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\HashType
     */
    public $HashedPIN;
    /**
     * Constructor method for QRCodeIdentificationType
     * @uses QRCodeIdentificationType::setEVCOID()
     * @uses QRCodeIdentificationType::setPIN()
     * @uses QRCodeIdentificationType::setHashedPIN()
     * @param string $eVCOID
     * @param string $pIN
     * @param \StructType\HashType $hashedPIN
     */
    public function __construct($eVCOID = null, $pIN = null, \StructType\HashType $hashedPIN = null)
    {
        $this
            ->setEVCOID($eVCOID)
            ->setPIN($pIN)
            ->setHashedPIN($hashedPIN);
    }
    /**
     * Get EVCOID value
     * @return string
     */
    public function getEVCOID()
    {
        return $this->EVCOID;
    }
    /**
     * Set EVCOID value
     * @param string $eVCOID
     * @return \StructType\QRCodeIdentificationType
     */
    public function setEVCOID($eVCOID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($eVCOID) && !preg_match('/([A-Za-z]{2}\\-?[A-Za-z0-9]{3}\\-?C[A-Za-z0-9]{8}[\\*|\\-]?[\\d|X])|([A-Za-z]{2}[\\*|\\-]?[A-Za-z0-9]{3}[\\*|\\-]?[A-Za-z0-9]{6}[\\*|\\-]?[\\d|X])/', $eVCOID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([A-Za-z]{2}\-?[A-Za-z0-9]{3}\-?C[A-Za-z0-9]{8}[\*|\-]?[\d|X])|([A-Za-z]{2}[\*|\-]?[A-Za-z0-9]{3}[\*|\-]?[A-Za-z0-9]{6}[\*|\-]?[\d|X])", "%s" given', var_export($eVCOID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($eVCOID) && !is_string($eVCOID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eVCOID)), __LINE__);
        }
        $this->EVCOID = $eVCOID;
        return $this;
    }
    /**
     * Get PIN value
     * @return string
     */
    public function getPIN()
    {
        return $this->PIN;
    }
    /**
     * Set PIN value
     * @param string $pIN
     * @return \StructType\QRCodeIdentificationType
     */
    public function setPIN($pIN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pIN) && strlen($pIN) > 20) || (is_array($pIN) && count($pIN) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($pIN) ? strlen($pIN) : count($pIN)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pIN) && !is_string($pIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pIN)), __LINE__);
        }
        $this->PIN = $pIN;
        return $this;
    }
    /**
     * Get HashedPIN value
     * @return \StructType\HashType
     */
    public function getHashedPIN()
    {
        return $this->HashedPIN;
    }
    /**
     * Set HashedPIN value
     * @param \StructType\HashType $hashedPIN
     * @return \StructType\QRCodeIdentificationType
     */
    public function setHashedPIN(\StructType\HashType $hashedPIN = null)
    {
        $this->HashedPIN = $hashedPIN;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\QRCodeIdentificationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
